"use strict";function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)}(function($){var Canvas=function Canvas(cls,container){var element=container.getElementsByClassName(cls)[0];if(!element){element=document.createElement("canvas");element.className=cls;element.style.direction="ltr";element.style.position="absolute";element.style.left="0px";element.style.top="0px";container.appendChild(element);if(!element.getContext){throw new Error("Canvas is not available.")}}this.element=element;var context=this.context=element.getContext("2d");this.pixelRatio=$.plot.browser.getPixelRatio(context);var width=$(container).width();var height=$(container).height();this.resize(width,height);this.SVGContainer=null;this.SVG={};this._textCache={}};Canvas.prototype.resize=function(width,height){var minSize=10;width=width<minSize?minSize:width;height=height<minSize?minSize:height;var element=this.element,context=this.context,pixelRatio=this.pixelRatio;if(this.width!==width){element.width=width*pixelRatio;element.style.width=width+"px";this.width=width}if(this.height!==height){element.height=height*pixelRatio;element.style.height=height+"px";this.height=height}context.restore();context.save();context.scale(pixelRatio,pixelRatio)};Canvas.prototype.clear=function(){this.context.clearRect(0,0,this.width,this.height)};Canvas.prototype.render=function(){var cache=this._textCache;for(var layerKey in cache){if(hasOwnProperty.call(cache,layerKey)){var layer=this.getSVGLayer(layerKey),layerCache=cache[layerKey];var display=layer.style.display;layer.style.display="none";for(var styleKey in layerCache){if(hasOwnProperty.call(layerCache,styleKey)){var styleCache=layerCache[styleKey];for(var key in styleCache){if(hasOwnProperty.call(styleCache,key)){var val=styleCache[key],positions=val.positions;for(var i=0,position;positions[i];i++){position=positions[i];if(position.active){if(!position.rendered){layer.appendChild(position.element);position.rendered=true}}else{positions.splice(i--,1);if(position.rendered){while(position.element.firstChild){position.element.removeChild(position.element.firstChild)}position.element.parentNode.removeChild(position.element)}}}if(positions.length===0){if(val.measured){val.measured=false}else{delete styleCache[key]}}}}}}layer.style.display=display}}};Canvas.prototype.getSVGLayer=function(classes){var layer=this.SVG[classes];if(!layer){var svgElement;if(!this.SVGContainer){this.SVGContainer=document.createElement("div");this.SVGContainer.className="flot-svg";this.SVGContainer.style.position="absolute";this.SVGContainer.style.top="0px";this.SVGContainer.style.left="0px";this.SVGContainer.style.height="100%";this.SVGContainer.style.width="100%";this.SVGContainer.style.pointerEvents="none";this.element.parentNode.appendChild(this.SVGContainer);svgElement=document.createElementNS("http://www.w3.org/2000/svg","svg");svgElement.style.width="100%";svgElement.style.height="100%";this.SVGContainer.appendChild(svgElement)}else{svgElement=this.SVGContainer.firstChild}layer=document.createElementNS("http://www.w3.org/2000/svg","g");layer.setAttribute("class",classes);layer.style.position="absolute";layer.style.top="0px";layer.style.left="0px";layer.style.bottom="0px";layer.style.right="0px";svgElement.appendChild(layer);this.SVG[classes]=layer}return layer};Canvas.prototype.getTextInfo=function(layer,text,font,angle,width){var textStyle,layerCache,styleCache,info;text=""+text;if(_typeof(font)==="object"){textStyle=font.style+" "+font.variant+" "+font.weight+" "+font.size+"px/"+font.lineHeight+"px "+font.family}else{textStyle=font}layerCache=this._textCache[layer];if(layerCache==null){layerCache=this._textCache[layer]={}}styleCache=layerCache[textStyle];if(styleCache==null){styleCache=layerCache[textStyle]={}}var key=generateKey(text);info=styleCache[key];if(!info){var element=document.createElementNS("http://www.w3.org/2000/svg","text");if(text.indexOf("<br>")!==-1){addTspanElements(text,element,-9999)}else{var textNode=document.createTextNode(text);element.appendChild(textNode)}element.style.position="absolute";element.style.maxWidth=width;element.setAttributeNS(null,"x",-9999);element.setAttributeNS(null,"y",-9999);if(_typeof(font)==="object"){element.style.font=textStyle;element.style.fill=font.fill}else if(typeof font==="string"){element.setAttribute("class",font)}this.getSVGLayer(layer).appendChild(element);var elementRect=element.getBBox();info=styleCache[key]={width:elementRect.width,height:elementRect.height,measured:true,element:element,positions:[]};while(element.firstChild){element.removeChild(element.firstChild)}element.parentNode.removeChild(element)}info.measured=true;return info};function updateTransforms(element,transforms){element.transform.baseVal.clear();if(transforms){transforms.forEach(function(t){element.transform.baseVal.appendItem(t)})}}Canvas.prototype.addText=function(layer,x,y,text,font,angle,width,halign,valign,transforms){var info=this.getTextInfo(layer,text,font,angle,width),positions=info.positions;if(halign==="center"){x-=info.width/2}else if(halign==="right"){x-=info.width}if(valign==="middle"){y-=info.height/2}else if(valign==="bottom"){y-=info.height}y+=.75*info.height;for(var i=0,position;positions[i];i++){position=positions[i];if(position.x===x&&position.y===y&&position.text===text){position.active=true;updateTransforms(position.element,transforms);return}else if(position.active===false){position.active=true;position.text=text;if(text.indexOf("<br>")!==-1){y-=.25*info.height;addTspanElements(text,position.element,x)}else{position.element.textContent=text}position.element.setAttributeNS(null,"x",x);position.element.setAttributeNS(null,"y",y);position.x=x;position.y=y;updateTransforms(position.element,transforms);return}}position={active:true,rendered:false,element:positions.length?info.element.cloneNode():info.element,text:text,x:x,y:y};positions.push(position);if(text.indexOf("<br>")!==-1){y-=.25*info.height;addTspanElements(text,position.element,x)}else{position.element.textContent=text}position.element.setAttributeNS(null,"x",x);position.element.setAttributeNS(null,"y",y);position.element.style.textAlign=halign;updateTransforms(position.element,transforms)};var addTspanElements=function addTspanElements(text,element,x){var lines=text.split("<br>"),tspan,i,offset;for(i=0;i<lines.length;i++){if(!element.childNodes[i]){tspan=document.createElementNS("http://www.w3.org/2000/svg","tspan");element.appendChild(tspan)}else{tspan=element.childNodes[i]}tspan.textContent=lines[i];offset=(i===0?0:1)+"em";tspan.setAttributeNS(null,"dy",offset);tspan.setAttributeNS(null,"x",x)}};Canvas.prototype.removeText=function(layer,x,y,text,font,angle){var info,htmlYCoord;if(text==null){var layerCache=this._textCache[layer];if(layerCache!=null){for(var styleKey in layerCache){if(hasOwnProperty.call(layerCache,styleKey)){var styleCache=layerCache[styleKey];for(var key in styleCache){if(hasOwnProperty.call(styleCache,key)){var positions=styleCache[key].positions;positions.forEach(function(position){position.active=false})}}}}}}else{info=this.getTextInfo(layer,text,font,angle);positions=info.positions;positions.forEach(function(position){htmlYCoord=y+.75*info.height;if(position.x===x&&position.y===htmlYCoord&&position.text===text){position.active=false}})}};Canvas.prototype.clearCache=function(){var cache=this._textCache;for(var layerKey in cache){if(hasOwnProperty.call(cache,layerKey)){var layer=this.getSVGLayer(layerKey);while(layer.firstChild){layer.removeChild(layer.firstChild)}}}this._textCache={}};function generateKey(text){return text.replace(/0|1|2|3|4|5|6|7|8|9/g,"0")}if(!window.Flot){window.Flot={}}window.Flot.Canvas=Canvas})(jQuery);(function($){$.color={};$.color.make=function(r,g,b,a){var o={};o.r=r||0;o.g=g||0;o.b=b||0;o.a=a!=null?a:1;o.add=function(c,d){for(var i=0;i<c.length;++i){o[c.charAt(i)]+=d}return o.normalize()};o.scale=function(c,f){for(var i=0;i<c.length;++i){o[c.charAt(i)]*=f}return o.normalize()};o.toString=function(){if(o.a>=1){return"rgb("+[o.r,o.g,o.b].join(",")+")"}else{return"rgba("+[o.r,o.g,o.b,o.a].join(",")+")"}};o.normalize=function(){function clamp(min,value,max){return value<min?min:value>max?max:value}o.r=clamp(0,parseInt(o.r),255);o.g=clamp(0,parseInt(o.g),255);o.b=clamp(0,parseInt(o.b),255);o.a=clamp(0,o.a,1);return o};o.clone=function(){return $.color.make(o.r,o.b,o.g,o.a)};return o.normalize()};$.color.extract=function(elem,css){var c;do{c=elem.css(css).toLowerCase();if(c!==""&&c!=="transparent"){break}elem=elem.parent()}while(elem.length&&!$.nodeName(elem.get(0),"body"));if(c==="rgba(0, 0, 0, 0)"){c="transparent"}return $.color.parse(c)};$.color.parse=function(str){var res,m=$.color.make;res=/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(str);if(res){return m(parseInt(res[1],10),parseInt(res[2],10),parseInt(res[3],10))}res=/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str);if(res){return m(parseInt(res[1],10),parseInt(res[2],10),parseInt(res[3],10),parseFloat(res[4]))}res=/rgb\(\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*\)/.exec(str);if(res){return m(parseFloat(res[1])*2.55,parseFloat(res[2])*2.55,parseFloat(res[3])*2.55)}res=/rgba\(\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str);if(res){return m(parseFloat(res[1])*2.55,parseFloat(res[2])*2.55,parseFloat(res[3])*2.55,parseFloat(res[4]))}res=/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(str);if(res){return m(parseInt(res[1],16),parseInt(res[2],16),parseInt(res[3],16))}res=/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(str);if(res){return m(parseInt(res[1]+res[1],16),parseInt(res[2]+res[2],16),parseInt(res[3]+res[3],16))}var name=$.trim(str).toLowerCase();if(name==="transparent"){return m(255,255,255,0)}else{res=lookupColors[name]||[0,0,0];return m(res[0],res[1],res[2])}};var lookupColors={aqua:[0,255,255],azure:[240,255,255],beige:[245,245,220],black:[0,0,0],blue:[0,0,255],brown:[165,42,42],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgrey:[169,169,169],darkgreen:[0,100,0],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkviolet:[148,0,211],fuchsia:[255,0,255],gold:[255,215,0],green:[0,128,0],indigo:[75,0,130],khaki:[240,230,140],lightblue:[173,216,230],lightcyan:[224,255,255],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightyellow:[255,255,224],lime:[0,255,0],magenta:[255,0,255],maroon:[128,0,0],navy:[0,0,128],olive:[128,128,0],orange:[255,165,0],pink:[255,192,203],purple:[128,0,128],violet:[128,0,128],red:[255,0,0],silver:[192,192,192],white:[255,255,255],yellow:[255,255,0]}})(jQuery);(function($){$.color={};$.color.make=function(r,g,b,a){var o={};o.r=r||0;o.g=g||0;o.b=b||0;o.a=a!=null?a:1;o.add=function(c,d){for(var i=0;i<c.length;++i){o[c.charAt(i)]+=d}return o.normalize()};o.scale=function(c,f){for(var i=0;i<c.length;++i){o[c.charAt(i)]*=f}return o.normalize()};o.toString=function(){if(o.a>=1){return"rgb("+[o.r,o.g,o.b].join(",")+")"}else{return"rgba("+[o.r,o.g,o.b,o.a].join(",")+")"}};o.normalize=function(){function clamp(min,value,max){return value<min?min:value>max?max:value}o.r=clamp(0,parseInt(o.r),255);o.g=clamp(0,parseInt(o.g),255);o.b=clamp(0,parseInt(o.b),255);o.a=clamp(0,o.a,1);return o};o.clone=function(){return $.color.make(o.r,o.b,o.g,o.a)};return o.normalize()};$.color.extract=function(elem,css){var c;do{c=elem.css(css).toLowerCase();if(c!==""&&c!=="transparent"){break}elem=elem.parent()}while(elem.length&&!$.nodeName(elem.get(0),"body"));if(c==="rgba(0, 0, 0, 0)"){c="transparent"}return $.color.parse(c)};$.color.parse=function(str){var res,m=$.color.make;res=/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(str);if(res){return m(parseInt(res[1],10),parseInt(res[2],10),parseInt(res[3],10))}res=/rgba\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str);if(res){return m(parseInt(res[1],10),parseInt(res[2],10),parseInt(res[3],10),parseFloat(res[4]))}res=/rgb\(\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*\)/.exec(str);if(res){return m(parseFloat(res[1])*2.55,parseFloat(res[2])*2.55,parseFloat(res[3])*2.55)}res=/rgba\(\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)%\s*,\s*([0-9]+(?:\.[0-9]+)?)\s*\)/.exec(str);if(res){return m(parseFloat(res[1])*2.55,parseFloat(res[2])*2.55,parseFloat(res[3])*2.55,parseFloat(res[4]))}res=/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(str);if(res){return m(parseInt(res[1],16),parseInt(res[2],16),parseInt(res[3],16))}res=/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(str);if(res){return m(parseInt(res[1]+res[1],16),parseInt(res[2]+res[2],16),parseInt(res[3]+res[3],16))}var name=$.trim(str).toLowerCase();if(name==="transparent"){return m(255,255,255,0)}else{res=lookupColors[name]||[0,0,0];return m(res[0],res[1],res[2])}};var lookupColors={aqua:[0,255,255],azure:[240,255,255],beige:[245,245,220],black:[0,0,0],blue:[0,0,255],brown:[165,42,42],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgrey:[169,169,169],darkgreen:[0,100,0],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkviolet:[148,0,211],fuchsia:[255,0,255],gold:[255,215,0],green:[0,128,0],indigo:[75,0,130],khaki:[240,230,140],lightblue:[173,216,230],lightcyan:[224,255,255],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightyellow:[255,255,224],lime:[0,255,0],magenta:[255,0,255],maroon:[128,0,0],navy:[0,0,128],olive:[128,128,0],orange:[255,165,0],pink:[255,192,203],purple:[128,0,128],violet:[128,0,128],red:[255,0,0],silver:[192,192,192],white:[255,255,255],yellow:[255,255,0]}})(jQuery);(function($){"use strict";var Canvas=window.Flot.Canvas;function defaultTickGenerator(axis){var ticks=[],start=$.plot.saturated.saturate($.plot.saturated.floorInBase(axis.min,axis.tickSize)),i=0,v=Number.NaN,prev;if(start===-Number.MAX_VALUE){ticks.push(start);start=$.plot.saturated.floorInBase(axis.min+axis.tickSize,axis.tickSize)}do{prev=v;v=$.plot.saturated.multiplyAdd(axis.tickSize,i,start);ticks.push(v);++i}while(v<axis.max&&v!==prev);return ticks}function defaultTickFormatter(value,axis,precision){var oldTickDecimals=axis.tickDecimals,expPosition=(""+value).indexOf("e");if(expPosition!==-1){return expRepTickFormatter(value,axis,precision)}if(precision>0){axis.tickDecimals=precision}var factor=axis.tickDecimals?parseFloat("1e"+axis.tickDecimals):1,formatted=""+Math.round(value*factor)/factor;if(axis.tickDecimals!=null){var decimal=formatted.indexOf("."),decimalPrecision=decimal===-1?0:formatted.length-decimal-1;if(decimalPrecision<axis.tickDecimals){var decimals=(""+factor).substr(1,axis.tickDecimals-decimalPrecision);formatted=(decimalPrecision?formatted:formatted+".")+decimals}}axis.tickDecimals=oldTickDecimals;return formatted}function expRepTickFormatter(value,axis,precision){var expPosition=(""+value).indexOf("e"),exponentValue=parseInt((""+value).substr(expPosition+1)),tenExponent=expPosition!==-1?exponentValue:value>0?Math.floor(Math.log(value)/Math.LN10):0,roundWith=parseFloat("1e"+tenExponent),x=value/roundWith;if(precision){var updatedPrecision=recomputePrecision(value,precision);return(value/roundWith).toFixed(updatedPrecision)+"e"+tenExponent}if(axis.tickDecimals>0){return x.toFixed(recomputePrecision(value,axis.tickDecimals))+"e"+tenExponent}return x.toFixed()+"e"+tenExponent}function recomputePrecision(num,precision){var log10Value=Math.log(Math.abs(num))*Math.LOG10E,newPrecision=Math.abs(log10Value+precision);return newPrecision<=20?Math.floor(newPrecision):20}function Plot(placeholder,data_,options_,plugins){var series=[],options={colors:["#edc240","#afd8f8","#cb4b4b","#4da74d","#9440ed"],xaxis:{show:null,position:"bottom",mode:null,font:null,color:null,tickColor:null,transform:null,inverseTransform:null,min:null,max:null,autoScaleMargin:null,autoScale:"exact",windowSize:null,growOnly:null,ticks:null,tickFormatter:null,showTickLabels:"major",labelWidth:null,labelHeight:null,reserveSpace:null,tickLength:null,showMinorTicks:null,showTicks:null,gridLines:null,alignTicksWithAxis:null,tickDecimals:null,tickSize:null,minTickSize:null,offset:{below:0,above:0},boxPosition:{centerX:0,centerY:0}},yaxis:{autoScaleMargin:.02,autoScale:"loose",growOnly:null,position:"left",showTickLabels:"major",offset:{below:0,above:0},boxPosition:{centerX:0,centerY:0}},xaxes:[],yaxes:[],series:{points:{show:false,radius:3,lineWidth:2,fill:true,fillColor:"#ffffff",symbol:"circle"},lines:{lineWidth:1,fill:false,fillColor:null,steps:false},bars:{show:false,lineWidth:2,horizontal:false,barWidth:.8,fill:true,fillColor:null,align:"left",zero:true},shadowSize:3,highlightColor:null},grid:{show:true,aboveData:false,color:"#545454",backgroundColor:null,borderColor:null,tickColor:null,margin:0,labelMargin:5,axisMargin:8,borderWidth:1,minBorderMargin:null,markings:null,markingsColor:"#f4f4f4",markingsLineWidth:2,clickable:false,hoverable:false,autoHighlight:true,mouseActiveRadius:15},interaction:{redrawOverlayInterval:1e3/60},hooks:{}},surface=null,overlay=null,eventHolder=null,ctx=null,octx=null,xaxes=[],yaxes=[],plotOffset={left:0,right:0,top:0,bottom:0},plotWidth=0,plotHeight=0,hooks={processOptions:[],processRawData:[],processDatapoints:[],processOffset:[],setupGrid:[],adjustSeriesDataRange:[],setRange:[],drawBackground:[],drawSeries:[],drawAxis:[],draw:[],findNearbyItems:[],axisReserveSpace:[],bindEvents:[],drawOverlay:[],resize:[],shutdown:[]},plot=this;var eventManager={};var redrawTimeout=null;plot.setData=setData;plot.setupGrid=setupGrid;plot.draw=draw;plot.getPlaceholder=function(){return placeholder};plot.getCanvas=function(){return surface.element};plot.getSurface=function(){return surface};plot.getEventHolder=function(){return eventHolder[0]};plot.getPlotOffset=function(){return plotOffset};plot.width=function(){return plotWidth};plot.height=function(){return plotHeight};plot.offset=function(){var o=eventHolder.offset();o.left+=plotOffset.left;o.top+=plotOffset.top;return o};plot.getData=function(){return series};plot.getAxes=function(){var res={};$.each(xaxes.concat(yaxes),function(_,axis){if(axis){res[axis.direction+(axis.n!==1?axis.n:"")+"axis"]=axis}});return res};plot.getXAxes=function(){return xaxes};plot.getYAxes=function(){return yaxes};plot.c2p=canvasToCartesianAxisCoords;plot.p2c=cartesianAxisToCanvasCoords;plot.getOptions=function(){return options};plot.triggerRedrawOverlay=triggerRedrawOverlay;plot.pointOffset=function(point){return{left:parseInt(xaxes[axisNumber(point,"x")-1].p2c(+point.x)+plotOffset.left,10),top:parseInt(yaxes[axisNumber(point,"y")-1].p2c(+point.y)+plotOffset.top,10)}};plot.shutdown=shutdown;plot.destroy=function(){shutdown();placeholder.removeData("plot").empty();series=[];options=null;surface=null;overlay=null;eventHolder=null;ctx=null;octx=null;xaxes=[];yaxes=[];hooks=null;plot=null};plot.resize=function(){var width=placeholder.width(),height=placeholder.height();surface.resize(width,height);overlay.resize(width,height);executeHooks(hooks.resize,[width,height])};plot.clearTextCache=function(){surface.clearCache();overlay.clearCache()};plot.autoScaleAxis=autoScaleAxis;plot.computeRangeForDataSeries=computeRangeForDataSeries;plot.adjustSeriesDataRange=adjustSeriesDataRange;plot.findNearbyItem=findNearbyItem;plot.findNearbyItems=findNearbyItems;plot.findNearbyInterpolationPoint=findNearbyInterpolationPoint;plot.computeValuePrecision=computeValuePrecision;plot.computeTickSize=computeTickSize;plot.addEventHandler=addEventHandler;plot.hooks=hooks;var MINOR_TICKS_COUNT_CONSTANT=$.plot.uiConstants.MINOR_TICKS_COUNT_CONSTANT;var TICK_LENGTH_CONSTANT=$.plot.uiConstants.TICK_LENGTH_CONSTANT;initPlugins(plot);setupCanvases();parseOptions(options_);setData(data_);setupGrid(true);draw();bindEvents();function executeHooks(hook,args){args=[plot].concat(args);for(var i=0;i<hook.length;++i){hook[i].apply(this,args)}}function initPlugins(){var classes={Canvas:Canvas};for(var i=0;i<plugins.length;++i){var p=plugins[i];p.init(plot,classes);if(p.options){$.extend(true,options,p.options)}}}function parseOptions(opts){$.extend(true,options,opts);if(opts&&opts.colors){options.colors=opts.colors}if(options.xaxis.color==null){options.xaxis.color=$.color.parse(options.grid.color).scale("a",.22).toString()}if(options.yaxis.color==null){options.yaxis.color=$.color.parse(options.grid.color).scale("a",.22).toString()}if(options.xaxis.tickColor==null){options.xaxis.tickColor=options.grid.tickColor||options.xaxis.color}if(options.yaxis.tickColor==null){options.yaxis.tickColor=options.grid.tickColor||options.yaxis.color}if(options.grid.borderColor==null){options.grid.borderColor=options.grid.color}if(options.grid.tickColor==null){options.grid.tickColor=$.color.parse(options.grid.color).scale("a",.22).toString()}var i,axisOptions,axisCount,fontSize=placeholder.css("font-size"),fontSizeDefault=fontSize?+fontSize.replace("px",""):13,fontDefaults={style:placeholder.css("font-style"),size:Math.round(.8*fontSizeDefault),variant:placeholder.css("font-variant"),weight:placeholder.css("font-weight"),family:placeholder.css("font-family")};axisCount=options.xaxes.length||1;for(i=0;i<axisCount;++i){axisOptions=options.xaxes[i];if(axisOptions&&!axisOptions.tickColor){axisOptions.tickColor=axisOptions.color}axisOptions=$.extend(true,{},options.xaxis,axisOptions);options.xaxes[i]=axisOptions;if(axisOptions.font){axisOptions.font=$.extend({},fontDefaults,axisOptions.font);if(!axisOptions.font.color){axisOptions.font.color=axisOptions.color}if(!axisOptions.font.lineHeight){axisOptions.font.lineHeight=Math.round(axisOptions.font.size*1.15)}}}axisCount=options.yaxes.length||1;for(i=0;i<axisCount;++i){axisOptions=options.yaxes[i];if(axisOptions&&!axisOptions.tickColor){axisOptions.tickColor=axisOptions.color}axisOptions=$.extend(true,{},options.yaxis,axisOptions);options.yaxes[i]=axisOptions;if(axisOptions.font){axisOptions.font=$.extend({},fontDefaults,axisOptions.font);if(!axisOptions.font.color){axisOptions.font.color=axisOptions.color}if(!axisOptions.font.lineHeight){axisOptions.font.lineHeight=Math.round(axisOptions.font.size*1.15)}}}for(i=0;i<options.xaxes.length;++i){getOrCreateAxis(xaxes,i+1).options=options.xaxes[i]}for(i=0;i<options.yaxes.length;++i){getOrCreateAxis(yaxes,i+1).options=options.yaxes[i]}$.each(allAxes(),function(_,axis){axis.boxPosition=axis.options.boxPosition||{centerX:0,centerY:0}});for(var n in hooks){if(options.hooks[n]&&options.hooks[n].length){hooks[n]=hooks[n].concat(options.hooks[n])}}executeHooks(hooks.processOptions,[options])}function setData(d){var oldseries=series;series=parseData(d);fillInSeriesOptions();processData(oldseries)}function parseData(d){var res=[];for(var i=0;i<d.length;++i){var s=$.extend(true,{},options.series);if(d[i].data!=null){s.data=d[i].data;delete d[i].data;$.extend(true,s,d[i]);d[i].data=s.data}else{s.data=d[i]}res.push(s)}return res}function axisNumber(obj,coord){var a=obj[coord+"axis"];if(_typeof(a)==="object"){a=a.n}if(typeof a!=="number"){a=1}return a}function allAxes(){return xaxes.concat(yaxes).filter(function(a){return a})}function canvasToCartesianAxisCoords(pos){var res={},i,axis;for(i=0;i<xaxes.length;++i){axis=xaxes[i];if(axis&&axis.used){res["x"+axis.n]=axis.c2p(pos.left)}}for(i=0;i<yaxes.length;++i){axis=yaxes[i];if(axis&&axis.used){res["y"+axis.n]=axis.c2p(pos.top)}}if(res.x1!==undefined){res.x=res.x1}if(res.y1!==undefined){res.y=res.y1}return res}function cartesianAxisToCanvasCoords(pos){var res={},i,axis,key;for(i=0;i<xaxes.length;++i){axis=xaxes[i];if(axis&&axis.used){key="x"+axis.n;if(pos[key]==null&&axis.n===1){key="x"}if(pos[key]!=null){res.left=axis.p2c(pos[key]);break}}}for(i=0;i<yaxes.length;++i){axis=yaxes[i];if(axis&&axis.used){key="y"+axis.n;if(pos[key]==null&&axis.n===1){key="y"}if(pos[key]!=null){res.top=axis.p2c(pos[key]);break}}}return res}function getOrCreateAxis(axes,number){if(!axes[number-1]){axes[number-1]={n:number,direction:axes===xaxes?"x":"y",options:$.extend(true,{},axes===xaxes?options.xaxis:options.yaxis)}}return axes[number-1]}function fillInSeriesOptions(){var neededColors=series.length,maxIndex=-1,i;for(i=0;i<series.length;++i){var sc=series[i].color;if(sc!=null){neededColors--;if(typeof sc==="number"&&sc>maxIndex){maxIndex=sc}}}if(neededColors<=maxIndex){neededColors=maxIndex+1}var c,colors=[],colorPool=options.colors,colorPoolSize=colorPool.length,variation=0,definedColors=Math.max(0,series.length-neededColors);for(i=0;i<neededColors;i++){c=$.color.parse(colorPool[(definedColors+i)%colorPoolSize]||"#666");if(i%colorPoolSize===0&&i){if(variation>=0){if(variation<.5){variation=-variation-.2}else variation=0}else variation=-variation}colors[i]=c.scale("rgb",1+variation)}var colori=0,s;for(i=0;i<series.length;++i){s=series[i];if(s.color==null){s.color=colors[colori].toString();++colori}else if(typeof s.color==="number"){s.color=colors[s.color].toString()}if(s.lines.show==null){var v,show=true;for(v in s){if(s[v]&&s[v].show){show=false;break}}if(show){s.lines.show=true}}if(s.lines.zero==null){s.lines.zero=!!s.lines.fill}s.xaxis=getOrCreateAxis(xaxes,axisNumber(s,"x"));s.yaxis=getOrCreateAxis(yaxes,axisNumber(s,"y"))}}function processData(prevSeries){var topSentry=Number.POSITIVE_INFINITY,bottomSentry=Number.NEGATIVE_INFINITY,i,j,k,m,s,points,ps,val,f,p,data,format;function updateAxis(axis,min,max){if(min<axis.datamin&&min!==-Infinity){axis.datamin=min}if(max>axis.datamax&&max!==Infinity){axis.datamax=max}}function reusePoints(prevSeries,i){if(prevSeries&&prevSeries[i]&&prevSeries[i].datapoints&&prevSeries[i].datapoints.points){return prevSeries[i].datapoints.points}return[]}$.each(allAxes(),function(_,axis){if(axis.options.growOnly!==true){axis.datamin=topSentry;axis.datamax=bottomSentry}else{if(axis.datamin===undefined){axis.datamin=topSentry}if(axis.datamax===undefined){axis.datamax=bottomSentry}}axis.used=false});for(i=0;i<series.length;++i){s=series[i];s.datapoints={points:[]};if(s.datapoints.points.length===0){s.datapoints.points=reusePoints(prevSeries,i)}executeHooks(hooks.processRawData,[s,s.data,s.datapoints])}for(i=0;i<series.length;++i){s=series[i];data=s.data;format=s.datapoints.format;if(!format){format=[];format.push({x:true,y:false,number:true,required:true,computeRange:s.xaxis.options.autoScale!=="none",defaultValue:null});format.push({x:false,y:true,number:true,required:true,computeRange:s.yaxis.options.autoScale!=="none",defaultValue:null});if(s.stack||s.bars.show||s.lines.show&&s.lines.fill){var expectedPs=s.datapoints.pointsize!=null?s.datapoints.pointsize:s.data&&s.data[0]&&s.data[0].length?s.data[0].length:3;if(expectedPs>2){format.push({x:s.bars.horizontal,y:!s.bars.horizontal,number:true,required:false,computeRange:s.yaxis.options.autoScale!=="none",defaultValue:0})}}s.datapoints.format=format}s.xaxis.used=s.yaxis.used=true;if(s.datapoints.pointsize!=null)continue;s.datapoints.pointsize=format.length;ps=s.datapoints.pointsize;points=s.datapoints.points;for(j=k=0;j<data.length;++j,k+=ps){p=data[j];var nullify=p==null;if(!nullify){for(m=0;m<ps;++m){val=p[m];f=format[m];if(f){if(f.number&&val!=null){val=+val;if(isNaN(val)){val=null}}if(val==null){if(f.required)nullify=true;if(f.defaultValue!=null)val=f.defaultValue}}points[k+m]=val}}if(nullify){for(m=0;m<ps;++m){val=points[k+m];if(val!=null){f=format[m];if(f.computeRange){if(f.x){updateAxis(s.xaxis,val,val)}if(f.y){updateAxis(s.yaxis,val,val)}}}points[k+m]=null}}}points.length=k}for(i=0;i<series.length;++i){s=series[i];executeHooks(hooks.processDatapoints,[s,s.datapoints])}for(i=0;i<series.length;++i){s=series[i];format=s.datapoints.format;if(format.every(function(f){return!f.computeRange})){continue}var range=plot.adjustSeriesDataRange(s,plot.computeRangeForDataSeries(s));executeHooks(hooks.adjustSeriesDataRange,[s,range]);updateAxis(s.xaxis,range.xmin,range.xmax);updateAxis(s.yaxis,range.ymin,range.ymax)}$.each(allAxes(),function(_,axis){if(axis.datamin===topSentry){axis.datamin=null}if(axis.datamax===bottomSentry){axis.datamax=null}})}function setupCanvases(){placeholder.css("padding",0).children().filter(function(){return!$(this).hasClass("flot-overlay")&&!$(this).hasClass("flot-base")}).remove();if(placeholder.css("position")==="static"){placeholder.css("position","relative")}surface=new Canvas("flot-base",placeholder[0]);overlay=new Canvas("flot-overlay",placeholder[0]);ctx=surface.context;octx=overlay.context;eventHolder=$(overlay.element).unbind();var existing=placeholder.data("plot");if(existing){existing.shutdown();overlay.clear()}placeholder.data("plot",plot)}function bindEvents(){executeHooks(hooks.bindEvents,[eventHolder])}function addEventHandler(event,handler,eventHolder,priority){var key=eventHolder+event;var eventList=eventManager[key]||[];eventList.push({event:event,handler:handler,eventHolder:eventHolder,priority:priority});eventList.sort(function(a,b){return b.priority-a.priority});eventList.forEach(function(eventData){eventData.eventHolder.unbind(eventData.event,eventData.handler);eventData.eventHolder.bind(eventData.event,eventData.handler)});eventManager[key]=eventList}function shutdown(){if(redrawTimeout){clearTimeout(redrawTimeout)}executeHooks(hooks.shutdown,[eventHolder])}function setTransformationHelpers(axis){function identity(x){return x}var s,m,t=axis.options.transform||identity,it=axis.options.inverseTransform;if(axis.direction==="x"){if(isFinite(t(axis.max)-t(axis.min))){s=axis.scale=plotWidth/Math.abs(t(axis.max)-t(axis.min))}else{s=axis.scale=1/Math.abs($.plot.saturated.delta(t(axis.min),t(axis.max),plotWidth))}m=Math.min(t(axis.max),t(axis.min))}else{if(isFinite(t(axis.max)-t(axis.min))){s=axis.scale=plotHeight/Math.abs(t(axis.max)-t(axis.min))}else{s=axis.scale=1/Math.abs($.plot.saturated.delta(t(axis.min),t(axis.max),plotHeight))}s=-s;m=Math.max(t(axis.max),t(axis.min))}if(t===identity){axis.p2c=function(p){if(isFinite(p-m)){return(p-m)*s}else{return(p/4-m/4)*s*4}}}else{axis.p2c=function(p){var tp=t(p);if(isFinite(tp-m)){return(tp-m)*s}else{return(tp/4-m/4)*s*4}}}if(!it){axis.c2p=function(c){return m+c/s}}else{axis.c2p=function(c){return it(m+c/s)}}}function measureTickLabels(axis){var opts=axis.options,ticks=opts.showTickLabels!=="none"&&axis.ticks?axis.ticks:[],showMajorTickLabels=opts.showTickLabels==="major"||opts.showTickLabels==="all",showEndpointsTickLabels=opts.showTickLabels==="endpoints"||opts.showTickLabels==="all",labelWidth=opts.labelWidth||0,labelHeight=opts.labelHeight||0,legacyStyles=axis.direction+"Axis "+axis.direction+axis.n+"Axis",layer="flot-"+axis.direction+"-axis flot-"+axis.direction+axis.n+"-axis "+legacyStyles,font=opts.font||"flot-tick-label tickLabel";for(var i=0;i<ticks.length;++i){var t=ticks[i];var label=t.label;if(!t.label||showMajorTickLabels===false&&i>0&&i<ticks.length-1||showEndpointsTickLabels===false&&(i===0||i===ticks.length-1)){continue}if(_typeof(t.label)==="object"){label=t.label.name}var info=surface.getTextInfo(layer,label,font);labelWidth=Math.max(labelWidth,info.width);labelHeight=Math.max(labelHeight,info.height)}axis.labelWidth=opts.labelWidth||labelWidth;axis.labelHeight=opts.labelHeight||labelHeight}function allocateAxisBoxFirstPhase(axis){executeHooks(hooks.axisReserveSpace,[axis]);var lw=axis.labelWidth,lh=axis.labelHeight,pos=axis.options.position,isXAxis=axis.direction==="x",tickLength=axis.options.tickLength,showTicks=axis.options.showTicks,showMinorTicks=axis.options.showMinorTicks,gridLines=axis.options.gridLines,axisMargin=options.grid.axisMargin,padding=options.grid.labelMargin,innermost=true,outermost=true,found=false;$.each(isXAxis?xaxes:yaxes,function(i,a){if(a&&(a.show||a.reserveSpace)){if(a===axis){found=true}else if(a.options.position===pos){if(found){outermost=false}else{innermost=false}}}});if(outermost){axisMargin=0}if(tickLength==null){tickLength=TICK_LENGTH_CONSTANT}if(showTicks==null){showTicks=true}if(showMinorTicks==null){showMinorTicks=true}if(gridLines==null){if(innermost){gridLines=true}else{gridLines=false}}if(!isNaN(+tickLength)){padding+=showTicks?+tickLength:0}if(isXAxis){lh+=padding;if(pos==="bottom"){plotOffset.bottom+=lh+axisMargin;axis.box={top:surface.height-plotOffset.bottom,height:lh}}else{axis.box={top:plotOffset.top+axisMargin,height:lh};plotOffset.top+=lh+axisMargin}}else{lw+=padding;if(pos==="left"){axis.box={left:plotOffset.left+axisMargin,width:lw};plotOffset.left+=lw+axisMargin}else{plotOffset.right+=lw+axisMargin;axis.box={left:surface.width-plotOffset.right,width:lw}}}axis.position=pos;axis.tickLength=tickLength;axis.showMinorTicks=showMinorTicks;axis.showTicks=showTicks;axis.gridLines=gridLines;axis.box.padding=padding;axis.innermost=innermost}function allocateAxisBoxSecondPhase(axis){if(axis.direction==="x"){axis.box.left=plotOffset.left-axis.labelWidth/2;axis.box.width=surface.width-plotOffset.left-plotOffset.right+axis.labelWidth}else{axis.box.top=plotOffset.top-axis.labelHeight/2;axis.box.height=surface.height-plotOffset.bottom-plotOffset.top+axis.labelHeight}}function adjustLayoutForThingsStickingOut(){var minMargin=options.grid.minBorderMargin,i;if(minMargin==null){minMargin=0;for(i=0;i<series.length;++i){minMargin=Math.max(minMargin,2*(series[i].points.radius+series[i].points.lineWidth/2))}}var a,offset={},margins={left:minMargin,right:minMargin,top:minMargin,bottom:minMargin};$.each(allAxes(),function(_,axis){if(axis.reserveSpace&&axis.ticks&&axis.ticks.length){if(axis.direction==="x"){margins.left=Math.max(margins.left,axis.labelWidth/2);margins.right=Math.max(margins.right,axis.labelWidth/2)}else{margins.bottom=Math.max(margins.bottom,axis.labelHeight/2);margins.top=Math.max(margins.top,axis.labelHeight/2)}}});for(a in margins){offset[a]=margins[a]-plotOffset[a]}$.each(xaxes.concat(yaxes),function(_,axis){alignAxisWithGrid(axis,offset,function(offset){return offset>0})});plotOffset.left=Math.ceil(Math.max(margins.left,plotOffset.left));plotOffset.right=Math.ceil(Math.max(margins.right,plotOffset.right));plotOffset.top=Math.ceil(Math.max(margins.top,plotOffset.top));plotOffset.bottom=Math.ceil(Math.max(margins.bottom,plotOffset.bottom))}function alignAxisWithGrid(axis,offset,isValid){if(axis.direction==="x"){if(axis.position==="bottom"&&isValid(offset.bottom)){axis.box.top-=Math.ceil(offset.bottom)}if(axis.position==="top"&&isValid(offset.top)){axis.box.top+=Math.ceil(offset.top)}}else{if(axis.position==="left"&&isValid(offset.left)){axis.box.left+=Math.ceil(offset.left)}if(axis.position==="right"&&isValid(offset.right)){axis.box.left-=Math.ceil(offset.right)}}}function setupGrid(autoScale){var i,a,axes=allAxes(),showGrid=options.grid.show;for(a in plotOffset){plotOffset[a]=0}executeHooks(hooks.processOffset,[plotOffset]);for(a in plotOffset){if(_typeof(options.grid.borderWidth)==="object"){plotOffset[a]+=showGrid?options.grid.borderWidth[a]:0}else{plotOffset[a]+=showGrid?options.grid.borderWidth:0}}$.each(axes,function(_,axis){var axisOpts=axis.options;axis.show=axisOpts.show==null?axis.used:axisOpts.show;axis.reserveSpace=axisOpts.reserveSpace==null?axis.show:axisOpts.reserveSpace;setupTickFormatter(axis);executeHooks(hooks.setRange,[axis,autoScale]);setRange(axis,autoScale)});if(showGrid){plotWidth=surface.width-plotOffset.left-plotOffset.right;plotHeight=surface.height-plotOffset.bottom-plotOffset.top;var allocatedAxes=$.grep(axes,function(axis){return axis.show||axis.reserveSpace});$.each(allocatedAxes,function(_,axis){setupTickGeneration(axis);setMajorTicks(axis);snapRangeToTicks(axis,axis.ticks,series);setTransformationHelpers(axis);setEndpointTicks(axis,series);measureTickLabels(axis)});for(i=allocatedAxes.length-1;i>=0;--i){allocateAxisBoxFirstPhase(allocatedAxes[i])}adjustLayoutForThingsStickingOut();$.each(allocatedAxes,function(_,axis){allocateAxisBoxSecondPhase(axis)})}if(options.grid.margin){for(a in plotOffset){var margin=options.grid.margin||0;plotOffset[a]+=typeof margin==="number"?margin:margin[a]||0}$.each(xaxes.concat(yaxes),function(_,axis){alignAxisWithGrid(axis,options.grid.margin,function(offset){return offset!==undefined&&offset!==null})})}plotWidth=surface.width-plotOffset.left-plotOffset.right;plotHeight=surface.height-plotOffset.bottom-plotOffset.top;$.each(axes,function(_,axis){setTransformationHelpers(axis)});if(showGrid){drawAxisLabels()}executeHooks(hooks.setupGrid,[])}function widenMinMax(minimum,maximum){var min=minimum===undefined?null:minimum;var max=maximum===undefined?null:maximum;var delta=max-min;if(delta===0){var widen=max===0?1:.01;var wmin=null;if(min==null){wmin-=widen}if(max==null||min!=null){max+=widen}if(wmin!=null){min=wmin}}return{min:min,max:max}}function autoScaleAxis(axis){var opts=axis.options,min=opts.min,max=opts.max,datamin=axis.datamin,datamax=axis.datamax,delta;switch(opts.autoScale){case"none":min=+(opts.min!=null?opts.min:datamin);max=+(opts.max!=null?opts.max:datamax);break;case"loose":if(datamin!=null&&datamax!=null){min=datamin;max=datamax;delta=$.plot.saturated.saturate(max-min);var margin=typeof opts.autoScaleMargin==="number"?opts.autoScaleMargin:.02;min=$.plot.saturated.saturate(min-delta*margin);max=$.plot.saturated.saturate(max+delta*margin);if(min<0&&datamin>=0){min=0}}else{min=opts.min;max=opts.max}break;case"exact":min=datamin!=null?datamin:opts.min;max=datamax!=null?datamax:opts.max;break;case"sliding-window":if(datamax>max){max=datamax;min=Math.max(datamax-(opts.windowSize||100),min)}break}var widenedMinMax=widenMinMax(min,max);min=widenedMinMax.min;max=widenedMinMax.max;if(opts.growOnly===true&&opts.autoScale!=="none"&&opts.autoScale!=="sliding-window"){min=min<datamin?min:datamin!==null?datamin:min;max=max>datamax?max:datamax!==null?datamax:max}axis.autoScaledMin=min;axis.autoScaledMax=max}function setRange(axis,autoScale){var min=typeof axis.options.min==="number"?axis.options.min:axis.min,max=typeof axis.options.max==="number"?axis.options.max:axis.max,plotOffset=axis.options.offset;if(autoScale){autoScaleAxis(axis);min=axis.autoScaledMin;max=axis.autoScaledMax}min=(min!=null?min:-1)+(plotOffset.below||0);max=(max!=null?max:1)+(plotOffset.above||0);if(min>max){var tmp=min;min=max;max=tmp;axis.options.offset={above:0,below:0}}axis.min=$.plot.saturated.saturate(min);axis.max=$.plot.saturated.saturate(max)}function computeValuePrecision(min,max,direction,ticks,tickDecimals){var noTicks=fixupNumberOfTicks(direction,surface,ticks);var delta=$.plot.saturated.delta(min,max,noTicks),dec=-Math.floor(Math.log(delta)/Math.LN10);if(tickDecimals&&dec>tickDecimals){dec=tickDecimals}var magn=parseFloat("1e"+-dec),norm=delta/magn;if(norm>2.25&&norm<3&&(tickDecimals==null||dec+1<=tickDecimals)){++dec}return isFinite(dec)?dec:0}function computeTickSize(min,max,noTicks,tickDecimals){var delta=$.plot.saturated.delta(min,max,noTicks),dec=-Math.floor(Math.log(delta)/Math.LN10);if(tickDecimals&&dec>tickDecimals){dec=tickDecimals}var magn=parseFloat("1e"+-dec),norm=delta/magn,size;if(norm<1.5){size=1}else if(norm<3){size=2;if(norm>2.25&&(tickDecimals==null||dec+1<=tickDecimals)){size=2.5}}else if(norm<7.5){size=5}else{size=10}size*=magn;return size}function getAxisTickSize(min,max,direction,options,tickDecimals){var noTicks;if(typeof options.ticks==="number"&&options.ticks>0){noTicks=options.ticks}else{noTicks=.3*Math.sqrt(direction==="x"?surface.width:surface.height)}var size=computeTickSize(min,max,noTicks,tickDecimals);if(options.minTickSize!=null&&size<options.minTickSize){size=options.minTickSize}return options.tickSize||size}function fixupNumberOfTicks(direction,surface,ticksOption){var noTicks;if(typeof ticksOption==="number"&&ticksOption>0){noTicks=ticksOption}else{noTicks=.3*Math.sqrt(direction==="x"?surface.width:surface.height)}return noTicks}function setupTickFormatter(axis){var opts=axis.options;if(!axis.tickFormatter){if(typeof opts.tickFormatter==="function"){axis.tickFormatter=function(){var args=Array.prototype.slice.call(arguments);return""+opts.tickFormatter.apply(null,args)}}else{axis.tickFormatter=defaultTickFormatter}}}function setupTickGeneration(axis){var opts=axis.options;var noTicks;noTicks=fixupNumberOfTicks(axis.direction,surface,opts.ticks);axis.delta=$.plot.saturated.delta(axis.min,axis.max,noTicks);var precision=plot.computeValuePrecision(axis.min,axis.max,axis.direction,noTicks,opts.tickDecimals);axis.tickDecimals=Math.max(0,opts.tickDecimals!=null?opts.tickDecimals:precision);axis.tickSize=getAxisTickSize(axis.min,axis.max,axis.direction,opts,opts.tickDecimals);if(!axis.tickGenerator){if(typeof opts.tickGenerator==="function"){axis.tickGenerator=opts.tickGenerator}else{axis.tickGenerator=defaultTickGenerator}}if(opts.alignTicksWithAxis!=null){var otherAxis=(axis.direction==="x"?xaxes:yaxes)[opts.alignTicksWithAxis-1];if(otherAxis&&otherAxis.used&&otherAxis!==axis){var niceTicks=axis.tickGenerator(axis,plot);if(niceTicks.length>0){if(opts.min==null){axis.min=Math.min(axis.min,niceTicks[0])}if(opts.max==null&&niceTicks.length>1){axis.max=Math.max(axis.max,niceTicks[niceTicks.length-1])}}axis.tickGenerator=function(axis){var ticks=[],v,i;for(i=0;i<otherAxis.ticks.length;++i){v=(otherAxis.ticks[i].v-otherAxis.min)/(otherAxis.max-otherAxis.min);v=axis.min+v*(axis.max-axis.min);ticks.push(v)}return ticks};if(!axis.mode&&opts.tickDecimals==null){var extraDec=Math.max(0,-Math.floor(Math.log(axis.delta)/Math.LN10)+1),ts=axis.tickGenerator(axis,plot);if(!(ts.length>1&&/\..*0$/.test((ts[1]-ts[0]).toFixed(extraDec)))){axis.tickDecimals=extraDec}}}}}function setMajorTicks(axis){var oticks=axis.options.ticks,ticks=[];if(oticks==null||typeof oticks==="number"&&oticks>0){ticks=axis.tickGenerator(axis,plot)}else if(oticks){if($.isFunction(oticks)){ticks=oticks(axis)}else{ticks=oticks}}var i,v;axis.ticks=[];for(i=0;i<ticks.length;++i){var label=null;var t=ticks[i];if(_typeof(t)==="object"){v=+t[0];if(t.length>1){label=t[1]}}else{v=+t}if(!isNaN(v)){axis.ticks.push(newTick(v,label,axis,"major"))}}}function newTick(v,label,axis,type){if(label===null){switch(type){case"min":case"max":var precision=getEndpointPrecision(v,axis);label=isFinite(precision)?axis.tickFormatter(v,axis,precision,plot):axis.tickFormatter(v,axis,precision,plot);break;case"major":label=axis.tickFormatter(v,axis,undefined,plot)}}return{v:v,label:label}}function snapRangeToTicks(axis,ticks,series){var anyDataInSeries=function anyDataInSeries(series){return series.some(function(e){return e.datapoints.points.length>0})};if(axis.options.autoScale==="loose"&&ticks.length>0&&anyDataInSeries(series)){axis.min=Math.min(axis.min,ticks[0].v);axis.max=Math.max(axis.max,ticks[ticks.length-1].v)}}function getEndpointPrecision(value,axis){var canvas1=Math.floor(axis.p2c(value)),canvas2=axis.direction==="x"?canvas1+1:canvas1-1,point1=axis.c2p(canvas1),point2=axis.c2p(canvas2),precision=computeValuePrecision(point1,point2,axis.direction,1);return precision}function setEndpointTicks(axis,series){if(isValidEndpointTick(axis,series)){axis.ticks.unshift(newTick(axis.min,null,axis,"min"));axis.ticks.push(newTick(axis.max,null,axis,"max"))}}function isValidEndpointTick(axis,series){if(axis.options.showTickLabels==="endpoints"){return true}if(axis.options.showTickLabels==="all"){var associatedSeries=series.filter(function(s){return s.bars.horizontal?s.yaxis===axis:s.xaxis===axis}),notAllBarSeries=associatedSeries.some(function(s){return!s.bars.show});return associatedSeries.length===0||notAllBarSeries}if(axis.options.showTickLabels==="major"||axis.options.showTickLabels==="none"){return false}}function draw(){surface.clear();executeHooks(hooks.drawBackground,[ctx]);var grid=options.grid;if(grid.show&&grid.backgroundColor){drawBackground()}if(grid.show&&!grid.aboveData){drawGrid()}for(var i=0;i<series.length;++i){executeHooks(hooks.drawSeries,[ctx,series[i],i,getColorOrGradient]);drawSeries(series[i])}executeHooks(hooks.draw,[ctx]);if(grid.show&&grid.aboveData){drawGrid()}surface.render();triggerRedrawOverlay()}function extractRange(ranges,coord){var axis,from,to,key,axes=allAxes();for(var i=0;i<axes.length;++i){axis=axes[i];if(axis.direction===coord){key=coord+axis.n+"axis";if(!ranges[key]&&axis.n===1){key=coord+"axis"}if(ranges[key]){from=ranges[key].from;to=ranges[key].to;break}}}if(!ranges[key]){axis=coord==="x"?xaxes[0]:yaxes[0];from=ranges[coord+"1"];to=ranges[coord+"2"]}if(from!=null&&to!=null&&from>to){var tmp=from;from=to;to=tmp}return{from:from,to:to,axis:axis}}function drawBackground(){ctx.save();ctx.translate(plotOffset.left,plotOffset.top);ctx.fillStyle=getColorOrGradient(options.grid.backgroundColor,plotHeight,0,"rgba(255, 255, 255, 0)");ctx.fillRect(0,0,plotWidth,plotHeight);ctx.restore()}function drawMarkings(){var markings=options.grid.markings,axes;if(markings){if($.isFunction(markings)){axes=plot.getAxes();axes.xmin=axes.xaxis.min;axes.xmax=axes.xaxis.max;axes.ymin=axes.yaxis.min;axes.ymax=axes.yaxis.max;markings=markings(axes)}var i;for(i=0;i<markings.length;++i){var m=markings[i],xrange=extractRange(m,"x"),yrange=extractRange(m,"y");if(xrange.from==null){xrange.from=xrange.axis.min}if(xrange.to==null){xrange.to=xrange.axis.max}if(yrange.from==null){yrange.from=yrange.axis.min}if(yrange.to==null){yrange.to=yrange.axis.max}if(xrange.to<xrange.axis.min||xrange.from>xrange.axis.max||yrange.to<yrange.axis.min||yrange.from>yrange.axis.max){continue}xrange.from=Math.max(xrange.from,xrange.axis.min);xrange.to=Math.min(xrange.to,xrange.axis.max);yrange.from=Math.max(yrange.from,yrange.axis.min);yrange.to=Math.min(yrange.to,yrange.axis.max);var xequal=xrange.from===xrange.to,yequal=yrange.from===yrange.to;if(xequal&&yequal){continue}xrange.from=Math.floor(xrange.axis.p2c(xrange.from));xrange.to=Math.floor(xrange.axis.p2c(xrange.to));yrange.from=Math.floor(yrange.axis.p2c(yrange.from));yrange.to=Math.floor(yrange.axis.p2c(yrange.to));if(xequal||yequal){var lineWidth=m.lineWidth||options.grid.markingsLineWidth,subPixel=lineWidth%2?.5:0;ctx.beginPath();ctx.strokeStyle=m.color||options.grid.markingsColor;ctx.lineWidth=lineWidth;if(xequal){ctx.moveTo(xrange.to+subPixel,yrange.from);ctx.lineTo(xrange.to+subPixel,yrange.to)}else{ctx.moveTo(xrange.from,yrange.to+subPixel);ctx.lineTo(xrange.to,yrange.to+subPixel)}ctx.stroke()}else{ctx.fillStyle=m.color||options.grid.markingsColor;ctx.fillRect(xrange.from,yrange.to,xrange.to-xrange.from,yrange.from-yrange.to)}}}}function findEdges(axis){var box=axis.box,x=0,y=0;if(axis.direction==="x"){x=0;y=box.top-plotOffset.top+(axis.position==="top"?box.height:0)}else{y=0;x=box.left-plotOffset.left+(axis.position==="left"?box.width:0)+axis.boxPosition.centerX}return{x:x,y:y}}function alignPosition(lineWidth,pos){return lineWidth%2!==0?Math.floor(pos)+.5:pos}function drawTickBar(axis){ctx.lineWidth=1;var edges=findEdges(axis),x=edges.x,y=edges.y;if(axis.show){var xoff=0,yoff=0;ctx.strokeStyle=axis.options.color;ctx.beginPath();if(axis.direction==="x"){xoff=plotWidth+1}else{yoff=plotHeight+1}if(axis.direction==="x"){y=alignPosition(ctx.lineWidth,y)}else{x=alignPosition(ctx.lineWidth,x)}ctx.moveTo(x,y);ctx.lineTo(x+xoff,y+yoff);ctx.stroke()}}function drawTickMarks(axis){var t=axis.tickLength,minorTicks=axis.showMinorTicks,minorTicksNr=MINOR_TICKS_COUNT_CONSTANT,edges=findEdges(axis),x=edges.x,y=edges.y,i=0;ctx.strokeStyle=axis.options.color;ctx.beginPath();for(i=0;i<axis.ticks.length;++i){var v=axis.ticks[i].v,xoff=0,yoff=0,xminor=0,yminor=0,j;if(!isNaN(v)&&v>=axis.min&&v<=axis.max){if(axis.direction==="x"){x=axis.p2c(v);yoff=t;if(axis.position==="top"){yoff=-yoff}}else{y=axis.p2c(v);xoff=t;if(axis.position==="left"){xoff=-xoff}}if(axis.direction==="x"){x=alignPosition(ctx.lineWidth,x)}else{y=alignPosition(ctx.lineWidth,y)}ctx.moveTo(x,y);ctx.lineTo(x+xoff,y+yoff)}if(minorTicks===true&&i<axis.ticks.length-1){var v1=axis.ticks[i].v,v2=axis.ticks[i+1].v,step=(v2-v1)/(minorTicksNr+1);for(j=1;j<=minorTicksNr;j++){if(axis.direction==="x"){yminor=t/2;x=alignPosition(ctx.lineWidth,axis.p2c(v1+j*step));if(axis.position==="top"){yminor=-yminor}if(x<0||x>plotWidth){continue}}else{xminor=t/2;y=alignPosition(ctx.lineWidth,axis.p2c(v1+j*step));if(axis.position==="left"){xminor=-xminor}if(y<0||y>plotHeight){continue}}ctx.moveTo(x,y);ctx.lineTo(x+xminor,y+yminor)}}}ctx.stroke()}function drawGridLines(axis){var overlappedWithBorder=function overlappedWithBorder(value){var bw=options.grid.borderWidth;return(_typeof(bw)==="object"&&bw[axis.position]>0||bw>0)&&(value===axis.min||value===axis.max)};ctx.strokeStyle=options.grid.tickColor;ctx.beginPath();var i;for(i=0;i<axis.ticks.length;++i){var v=axis.ticks[i].v,xoff=0,yoff=0,x=0,y=0;if(isNaN(v)||v<axis.min||v>axis.max)continue;if(overlappedWithBorder(v))continue;if(axis.direction==="x"){x=axis.p2c(v);y=plotHeight;yoff=-plotHeight}else{x=0;y=axis.p2c(v);xoff=plotWidth}if(axis.direction==="x"){x=alignPosition(ctx.lineWidth,x)}else{y=alignPosition(ctx.lineWidth,y)}ctx.moveTo(x,y);ctx.lineTo(x+xoff,y+yoff)}ctx.stroke()}function drawBorder(){var bw=options.grid.borderWidth,bc=options.grid.borderColor;if(_typeof(bw)==="object"||_typeof(bc)==="object"){if(_typeof(bw)!=="object"){bw={top:bw,right:bw,bottom:bw,left:bw}}if(_typeof(bc)!=="object"){bc={top:bc,right:bc,bottom:bc,left:bc}}if(bw.top>0){ctx.strokeStyle=bc.top;ctx.lineWidth=bw.top;ctx.beginPath();ctx.moveTo(0-bw.left,0-bw.top/2);ctx.lineTo(plotWidth,0-bw.top/2);ctx.stroke()}if(bw.right>0){ctx.strokeStyle=bc.right;ctx.lineWidth=bw.right;ctx.beginPath();ctx.moveTo(plotWidth+bw.right/2,0-bw.top);ctx.lineTo(plotWidth+bw.right/2,plotHeight);ctx.stroke()}if(bw.bottom>0){ctx.strokeStyle=bc.bottom;ctx.lineWidth=bw.bottom;ctx.beginPath();ctx.moveTo(plotWidth+bw.right,plotHeight+bw.bottom/2);ctx.lineTo(0,plotHeight+bw.bottom/2);ctx.stroke()}if(bw.left>0){ctx.strokeStyle=bc.left;ctx.lineWidth=bw.left;ctx.beginPath();ctx.moveTo(0-bw.left/2,plotHeight+bw.bottom);ctx.lineTo(0-bw.left/2,0);ctx.stroke()}}else{ctx.lineWidth=bw;ctx.strokeStyle=options.grid.borderColor;ctx.strokeRect(-bw/2,-bw/2,plotWidth+bw,plotHeight+bw)}}function drawGrid(){var axes,bw;ctx.save();ctx.translate(plotOffset.left,plotOffset.top);drawMarkings();axes=allAxes();bw=options.grid.borderWidth;for(var j=0;j<axes.length;++j){var axis=axes[j];if(!axis.show){continue}drawTickBar(axis);if(axis.showTicks===true){drawTickMarks(axis)}if(axis.gridLines===true){drawGridLines(axis,bw)}}if(bw){drawBorder()}ctx.restore()}function drawAxisLabels(){$.each(allAxes(),function(_,axis){var box=axis.box,legacyStyles=axis.direction+"Axis "+axis.direction+axis.n+"Axis",layer="flot-"+axis.direction+"-axis flot-"+axis.direction+axis.n+"-axis "+legacyStyles,font=axis.options.font||"flot-tick-label tickLabel",i,x,y,halign,valign,info,margin=3,nullBox={x:NaN,y:NaN,width:NaN,height:NaN},newLabelBox,labelBoxes=[],overlapping=function overlapping(x11,y11,x12,y12,x21,y21,x22,y22){return(x11<=x21&&x21<=x12||x21<=x11&&x11<=x22)&&(y11<=y21&&y21<=y12||y21<=y11&&y11<=y22)},overlapsOtherLabels=function overlapsOtherLabels(newLabelBox,previousLabelBoxes){return previousLabelBoxes.some(function(labelBox){return overlapping(newLabelBox.x,newLabelBox.y,newLabelBox.x+newLabelBox.width,newLabelBox.y+newLabelBox.height,labelBox.x,labelBox.y,labelBox.x+labelBox.width,labelBox.y+labelBox.height)})},drawAxisLabel=function drawAxisLabel(tick,labelBoxes){if(!tick||!tick.label||tick.v<axis.min||tick.v>axis.max){return nullBox}info=surface.getTextInfo(layer,tick.label,font);if(axis.direction==="x"){halign="center";x=plotOffset.left+axis.p2c(tick.v);if(axis.position==="bottom"){y=box.top+box.padding-axis.boxPosition.centerY}else{y=box.top+box.height-box.padding+axis.boxPosition.centerY;valign="bottom"}newLabelBox={x:x-info.width/2-margin,y:y-margin,width:info.width+2*margin,height:info.height+2*margin}}else{valign="middle";y=plotOffset.top+axis.p2c(tick.v);if(axis.position==="left"){x=box.left+box.width-box.padding-axis.boxPosition.centerX;halign="right"}else{x=box.left+box.padding+axis.boxPosition.centerX}newLabelBox={x:x-info.width/2-margin,y:y-margin,width:info.width+2*margin,height:info.height+2*margin}}if(overlapsOtherLabels(newLabelBox,labelBoxes)){return nullBox}surface.addText(layer,x,y,tick.label,font,null,null,halign,valign);return newLabelBox};surface.removeText(layer);executeHooks(hooks.drawAxis,[axis,surface]);if(!axis.show){return}switch(axis.options.showTickLabels){case"none":break;case"endpoints":labelBoxes.push(drawAxisLabel(axis.ticks[0],labelBoxes));labelBoxes.push(drawAxisLabel(axis.ticks[axis.ticks.length-1],labelBoxes));break;case"major":labelBoxes.push(drawAxisLabel(axis.ticks[0],labelBoxes));labelBoxes.push(drawAxisLabel(axis.ticks[axis.ticks.length-1],labelBoxes));for(i=1;i<axis.ticks.length-1;++i){labelBoxes.push(drawAxisLabel(axis.ticks[i],labelBoxes))}break;case"all":labelBoxes.push(drawAxisLabel(axis.ticks[0],[]));labelBoxes.push(drawAxisLabel(axis.ticks[axis.ticks.length-1],labelBoxes));for(i=1;i<axis.ticks.length-1;++i){labelBoxes.push(drawAxisLabel(axis.ticks[i],labelBoxes))}break}})}function drawSeries(series){if(series.lines.show){$.plot.drawSeries.drawSeriesLines(series,ctx,plotOffset,plotWidth,plotHeight,plot.drawSymbol,getColorOrGradient)}if(series.bars.show){$.plot.drawSeries.drawSeriesBars(series,ctx,plotOffset,plotWidth,plotHeight,plot.drawSymbol,getColorOrGradient)}if(series.points.show){$.plot.drawSeries.drawSeriesPoints(series,ctx,plotOffset,plotWidth,plotHeight,plot.drawSymbol,getColorOrGradient)}}function computeRangeForDataSeries(series,force,isValid){var points=series.datapoints.points,ps=series.datapoints.pointsize,format=series.datapoints.format,topSentry=Number.POSITIVE_INFINITY,bottomSentry=Number.NEGATIVE_INFINITY,range={xmin:topSentry,ymin:topSentry,xmax:bottomSentry,ymax:bottomSentry};for(var j=0;j<points.length;j+=ps){if(points[j]===null){continue}if(typeof isValid==="function"&&!isValid(points[j])){continue}for(var m=0;m<ps;++m){var val=points[j+m],f=format[m];if(f===null||f===undefined){continue}if(typeof isValid==="function"&&!isValid(val)){continue}if(!force&&!f.computeRange||val===Infinity||val===-Infinity){continue}if(f.x===true){if(val<range.xmin){range.xmin=val}if(val>range.xmax){range.xmax=val}}if(f.y===true){if(val<range.ymin){range.ymin=val}if(val>range.ymax){range.ymax=val}}}}return range}function adjustSeriesDataRange(series,range){if(series.bars.show){var delta;var useAbsoluteBarWidth=series.bars.barWidth[1];if(series.datapoints&&series.datapoints.points&&!useAbsoluteBarWidth){computeBarWidth(series)}var barWidth=series.bars.barWidth[0]||series.bars.barWidth;switch(series.bars.align){case"left":delta=0;break;case"right":delta=-barWidth;break;default:delta=-barWidth/2}if(series.bars.horizontal){range.ymin+=delta;range.ymax+=delta+barWidth}else{range.xmin+=delta;range.xmax+=delta+barWidth}}if(series.bars.show&&series.bars.zero||series.lines.show&&series.lines.zero){var ps=series.datapoints.pointsize;if(ps<=2){range.ymin=Math.min(0,range.ymin);range.ymax=Math.max(0,range.ymax)}}return range}function computeBarWidth(series){var xValues=[];var pointsize=series.datapoints.pointsize,minDistance=Number.MAX_VALUE;if(series.datapoints.points.length<=pointsize){minDistance=1}var start=series.bars.horizontal?1:0;for(var j=start;j<series.datapoints.points.length;j+=pointsize){if(isFinite(series.datapoints.points[j])&&series.datapoints.points[j]!==null){xValues.push(series.datapoints.points[j])}}function onlyUnique(value,index,self){return self.indexOf(value)===index}xValues=xValues.filter(onlyUnique);xValues.sort(function(a,b){return a-b});for(var _j=1;_j<xValues.length;_j++){var distance=Math.abs(xValues[_j]-xValues[_j-1]);if(distance<minDistance&&isFinite(distance)){minDistance=distance}}if(typeof series.bars.barWidth==="number"){series.bars.barWidth=series.bars.barWidth*minDistance}else{series.bars.barWidth[0]=series.bars.barWidth[0]*minDistance}}function findNearbyItems(mouseX,mouseY,seriesFilter,radius,computeDistance){var items=findItems(mouseX,mouseY,seriesFilter,radius,computeDistance);for(var i=0;i<series.length;++i){if(seriesFilter(i)){executeHooks(hooks.findNearbyItems,[mouseX,mouseY,series,i,radius,computeDistance,items])}}return items.sort(function(a,b){if(b.distance===undefined){return-1}else if(a.distance===undefined&&b.distance!==undefined){return 1}return a.distance-b.distance})}function findNearbyItem(mouseX,mouseY,seriesFilter,radius,computeDistance){var items=findNearbyItems(mouseX,mouseY,seriesFilter,radius,computeDistance);return items[0]!==undefined?items[0]:null}function findItems(mouseX,mouseY,seriesFilter,radius,computeDistance){var i,foundItems=[],items=[],smallestDistance=radius*radius+1;for(i=series.length-1;i>=0;--i){if(!seriesFilter(i))continue;var s=series[i];if(!s.datapoints)return;var foundPoint=false;if(s.lines.show||s.points.show){var found=findNearbyPoint(s,mouseX,mouseY,radius,computeDistance);if(found){items.push({seriesIndex:i,dataIndex:found.dataIndex,distance:found.distance});foundPoint=true}}if(s.bars.show&&!foundPoint){var foundIndex=findNearbyBar(s,mouseX,mouseY);if(foundIndex>=0){items.push({seriesIndex:i,dataIndex:foundIndex,distance:smallestDistance})}}}for(i=0;i<items.length;i++){var seriesIndex=items[i].seriesIndex;var dataIndex=items[i].dataIndex;var itemDistance=items[i].distance;var ps=series[seriesIndex].datapoints.pointsize;foundItems.push({datapoint:series[seriesIndex].datapoints.points.slice(dataIndex*ps,(dataIndex+1)*ps),dataIndex:dataIndex,series:series[seriesIndex],seriesIndex:seriesIndex,distance:Math.sqrt(itemDistance)})}return foundItems}function findNearbyPoint(series,mouseX,mouseY,maxDistance,computeDistance){var mx=series.xaxis.c2p(mouseX),my=series.yaxis.c2p(mouseY),maxx=maxDistance/series.xaxis.scale,maxy=maxDistance/series.yaxis.scale,points=series.datapoints.points,ps=series.datapoints.pointsize,smallestDistance=Number.POSITIVE_INFINITY;if(series.xaxis.options.inverseTransform){maxx=Number.MAX_VALUE}if(series.yaxis.options.inverseTransform){maxy=Number.MAX_VALUE}var found=null;for(var j=0;j<points.length;j+=ps){var x=points[j];var y=points[j+1];if(x==null){continue}if(x-mx>maxx||x-mx<-maxx||y-my>maxy||y-my<-maxy){continue}var dx=Math.abs(series.xaxis.p2c(x)-mouseX);var dy=Math.abs(series.yaxis.p2c(y)-mouseY);var dist=computeDistance?computeDistance(dx,dy):dx*dx+dy*dy;if(dist<smallestDistance){smallestDistance=dist;found={dataIndex:j/ps,distance:dist}}}return found}function findNearbyBar(series,mouseX,mouseY){var barLeft,barRight,barWidth=series.bars.barWidth[0]||series.bars.barWidth,mx=series.xaxis.c2p(mouseX),my=series.yaxis.c2p(mouseY),points=series.datapoints.points,ps=series.datapoints.pointsize;switch(series.bars.align){case"left":barLeft=0;break;case"right":barLeft=-barWidth;break;default:barLeft=-barWidth/2}barRight=barLeft+barWidth;var fillTowards=series.bars.fillTowards||0;var defaultBottom=fillTowards>series.yaxis.min?Math.min(series.yaxis.max,fillTowards):series.yaxis.min;var foundIndex=-1;for(var j=0;j<points.length;j+=ps){var x=points[j],y=points[j+1];if(x==null){continue}var bottom=ps===3?points[j+2]:defaultBottom;if(series.bars.horizontal?mx<=Math.max(bottom,x)&&mx>=Math.min(bottom,x)&&my>=y+barLeft&&my<=y+barRight:mx>=x+barLeft&&mx<=x+barRight&&my>=Math.min(bottom,y)&&my<=Math.max(bottom,y)){foundIndex=j/ps}}return foundIndex}function findNearbyInterpolationPoint(posX,posY,seriesFilter){var i,j,dist,dx,dy,ps,item,smallestDistance=Number.MAX_VALUE;for(i=0;i<series.length;++i){if(!seriesFilter(i)){continue}var points=series[i].datapoints.points;ps=series[i].datapoints.pointsize;var comparer=points[points.length-ps]<points[0]?function(x1,x2){return x1>x2}:function(x1,x2){return x2>x1};if(comparer(posX,points[0])){continue}for(j=ps;j<points.length;j+=ps){if(comparer(posX,points[j])){break}}var y,p1x=points[j-ps],p1y=points[j-ps+1],p2x=points[j],p2y=points[j+1];if(p1x===undefined||p2x===undefined||p1y===undefined||p2y===undefined){continue}if(p1x===p2x){y=p2y}else{y=p1y+(p2y-p1y)*(posX-p1x)/(p2x-p1x)}posY=y;dx=Math.abs(series[i].xaxis.p2c(p2x)-posX);dy=Math.abs(series[i].yaxis.p2c(p2y)-posY);dist=dx*dx+dy*dy;if(dist<smallestDistance){smallestDistance=dist;item=[posX,posY,i,j]}}if(item){i=item[2];j=item[3];ps=series[i].datapoints.pointsize;points=series[i].datapoints.points;p1x=points[j-ps];p1y=points[j-ps+1];p2x=points[j];p2y=points[j+1];return{datapoint:[item[0],item[1]],leftPoint:[p1x,p1y],rightPoint:[p2x,p2y],seriesIndex:i}}return null}function triggerRedrawOverlay(){var t=options.interaction.redrawOverlayInterval;if(t===-1){drawOverlay();return}if(!redrawTimeout){redrawTimeout=setTimeout(function(){drawOverlay(plot)},t)}}function drawOverlay(plot){redrawTimeout=null;if(!octx){return}overlay.clear();executeHooks(hooks.drawOverlay,[octx,overlay]);var event=new CustomEvent("onDrawingDone");plot.getEventHolder().dispatchEvent(event);plot.getPlaceholder().trigger("drawingdone")}function getColorOrGradient(spec,bottom,top,defaultColor){if(typeof spec==="string"){return spec}else{var gradient=ctx.createLinearGradient(0,top,0,bottom);for(var i=0,l=spec.colors.length;i<l;++i){var c=spec.colors[i];if(typeof c!=="string"){var co=$.color.parse(defaultColor);if(c.brightness!=null){co=co.scale("rgb",c.brightness)}if(c.opacity!=null){co.a*=c.opacity}c=co.toString()}gradient.addColorStop(i/(l-1),c)}return gradient}}}$.plot=function(placeholder,data,options){var plot=new Plot($(placeholder),data,options,$.plot.plugins);return plot};$.plot.version="3.0.0";$.plot.plugins=[];$.fn.plot=function(data,options){return this.each(function(){$.plot(this,data,options)})};$.plot.linearTickGenerator=defaultTickGenerator;$.plot.defaultTickFormatter=defaultTickFormatter;$.plot.expRepTickFormatter=expRepTickFormatter})(jQuery);(function($){"use strict";var saturated={saturate:function saturate(a){if(a===Infinity){return Number.MAX_VALUE}if(a===-Infinity){return-Number.MAX_VALUE}return a},delta:function delta(min,max,noTicks){return(max-min)/noTicks===Infinity?max/noTicks-min/noTicks:(max-min)/noTicks},multiply:function multiply(a,b){return saturated.saturate(a*b)},multiplyAdd:function multiplyAdd(a,bInt,c){if(isFinite(a*bInt)){return saturated.saturate(a*bInt+c)}else{var result=c;for(var i=0;i<bInt;i++){result+=a}return saturated.saturate(result)}},floorInBase:function floorInBase(n,base){return base*Math.floor(n/base)}};$.plot.saturated=saturated})(jQuery);(function($){"use strict";var browser={getPageXY:function getPageXY(e){var doc=document.documentElement,pageX=e.clientX+(window.pageXOffset||doc.scrollLeft)-(doc.clientLeft||0),pageY=e.clientY+(window.pageYOffset||doc.scrollTop)-(doc.clientTop||0);return{X:pageX,Y:pageY}},getPixelRatio:function getPixelRatio(context){var devicePixelRatio=window.devicePixelRatio||1,backingStoreRatio=context.webkitBackingStorePixelRatio||context.mozBackingStorePixelRatio||context.msBackingStorePixelRatio||context.oBackingStorePixelRatio||context.backingStorePixelRatio||1;return devicePixelRatio/backingStoreRatio},isSafari:function isSafari(){return/constructor/i.test(window.top.HTMLElement)||function(p){return p.toString()==="[object SafariRemoteNotification]"}(!window.top["safari"]||typeof window.top.safari!=="undefined"&&window.top.safari.pushNotification)},isMobileSafari:function isMobileSafari(){return navigator.userAgent.match(/(iPod|iPhone|iPad)/)&&navigator.userAgent.match(/AppleWebKit/)},isOpera:function isOpera(){return!!window.opr&&!!opr.addons||!!window.opera||navigator.userAgent.indexOf(" OPR/")>=0},isFirefox:function isFirefox(){return typeof InstallTrigger!=="undefined"},isIE:function isIE(){return false||!!document.documentMode},isEdge:function isEdge(){return!browser.isIE()&&!!window.StyleMedia},isChrome:function isChrome(){return!!window.chrome&&!!window.chrome.webstore},isBlink:function isBlink(){return(browser.isChrome()||browser.isOpera())&&!!window.CSS}};$.plot.browser=browser})(jQuery);(function($){"use strict";function DrawSeries(){function plotLine(datapoints,xoffset,yoffset,axisx,axisy,ctx,steps){var points=datapoints.points,ps=datapoints.pointsize,prevx=null,prevy=null;var x1=0,y1=0,x2=0,y2=0,mx=null,my=null,i=0;var initPoints=function initPoints(i){x1=points[i-ps];y1=points[i-ps+1];x2=points[i];y2=points[i+1]};var handleSteps=function handleSteps(){if(mx!==null&&my!==null){x2=x1;y2=y1;x1=mx;y1=my;mx=null;my=null;return true}else if(y1!==y2&&x1!==x2){y2=y1;mx=x2;my=y1}return false};var handleYMinClipping=function handleYMinClipping(){if(y1<=y2&&y1<axisy.min){if(y2<axisy.min){return true}x1=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1;y1=axisy.min}else if(y2<=y1&&y2<axisy.min){if(y1<axisy.min){return true}x2=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1;y2=axisy.min}};var handleYMaxClipping=function handleYMaxClipping(){if(y1>=y2&&y1>axisy.max){if(y2>axisy.max){return true}x1=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1;y1=axisy.max}else if(y2>=y1&&y2>axisy.max){if(y1>axisy.max){return true}x2=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1;y2=axisy.max}};var handleXMinClipping=function handleXMinClipping(){if(x1<=x2&&x1<axisx.min){if(x2<axisx.min){return true}y1=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1;x1=axisx.min}else if(x2<=x1&&x2<axisx.min){if(x1<axisx.min){return true}y2=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1;x2=axisx.min}};var handleXMaxClipping=function handleXMaxClipping(){if(x1>=x2&&x1>axisx.max){if(x2>axisx.max){return true}y1=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1;x1=axisx.max}else if(x2>=x1&&x2>axisx.max){if(x1>axisx.max){return true}y2=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1;x2=axisx.max}};var drawLine=function drawLine(){if(x1!==prevx||y1!==prevy){ctx.moveTo(axisx.p2c(x1)+xoffset,axisy.p2c(y1)+yoffset)}prevx=x2;prevy=y2;ctx.lineTo(axisx.p2c(x2)+xoffset,axisy.p2c(y2)+yoffset)};ctx.beginPath();for(i=ps;i<points.length;i+=ps){initPoints(i);if(x1===null||x2===null){mx=null;my=null;continue}if(isNaN(x1)||isNaN(x2)||isNaN(y1)||isNaN(y2)){prevx=null;prevy=null;continue}if(steps){var hadMiddlePoint=handleSteps();if(hadMiddlePoint){i-=ps}}if(handleYMinClipping())continue;if(handleYMaxClipping())continue;if(handleXMinClipping())continue;if(handleXMaxClipping())continue;drawLine()}if(mx!==null&&my!==null){initPoints(i);handleSteps();if(!handleYMinClipping()&&!handleYMaxClipping()&&!handleXMinClipping()&&!handleXMaxClipping()){drawLine()}}ctx.stroke()}function plotLineArea(datapoints,axisx,axisy,fillTowards,ctx,steps){var points=datapoints.points,ps=datapoints.pointsize,bottom=fillTowards>axisy.min?Math.min(axisy.max,fillTowards):axisy.min,i=0,ypos=1,areaOpen=false,segmentStart=0,segmentEnd=0,mx=null,my=null;while(true){if(ps>0&&i>points.length+ps){break}i+=ps;var x1=points[i-ps],y1=points[i-ps+ypos],x2=points[i],y2=points[i+ypos];if(ps===-2){y1=y2=bottom}if(areaOpen){if(ps>0&&x1!=null&&x2==null){segmentEnd=i;ps=-ps;ypos=2;continue}if(ps<0&&i===segmentStart+ps){ctx.fill();areaOpen=false;ps=-ps;ypos=1;i=segmentStart=segmentEnd+ps;continue}}if(x1==null||x2==null){mx=null;my=null;continue}if(steps){if(mx!==null&&my!==null){x2=x1;y2=y1;x1=mx;y1=my;mx=null;my=null;i-=ps}else if(y1!==y2&&x1!==x2){y2=y1;mx=x2;my=y1}}if(x1<=x2&&x1<axisx.min){if(x2<axisx.min){continue}y1=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1;x1=axisx.min}else if(x2<=x1&&x2<axisx.min){if(x1<axisx.min){continue}y2=(axisx.min-x1)/(x2-x1)*(y2-y1)+y1;x2=axisx.min}if(x1>=x2&&x1>axisx.max){if(x2>axisx.max){continue}y1=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1;x1=axisx.max}else if(x2>=x1&&x2>axisx.max){if(x1>axisx.max){continue}y2=(axisx.max-x1)/(x2-x1)*(y2-y1)+y1;x2=axisx.max}if(!areaOpen){ctx.beginPath();ctx.moveTo(axisx.p2c(x1),axisy.p2c(bottom));areaOpen=true}if(y1>=axisy.max&&y2>=axisy.max){ctx.lineTo(axisx.p2c(x1),axisy.p2c(axisy.max));ctx.lineTo(axisx.p2c(x2),axisy.p2c(axisy.max));continue}else if(y1<=axisy.min&&y2<=axisy.min){ctx.lineTo(axisx.p2c(x1),axisy.p2c(axisy.min));ctx.lineTo(axisx.p2c(x2),axisy.p2c(axisy.min));continue}var x1old=x1,x2old=x2;if(y1<=y2&&y1<axisy.min&&y2>=axisy.min){x1=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1;y1=axisy.min}else if(y2<=y1&&y2<axisy.min&&y1>=axisy.min){x2=(axisy.min-y1)/(y2-y1)*(x2-x1)+x1;y2=axisy.min}if(y1>=y2&&y1>axisy.max&&y2<=axisy.max){x1=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1;y1=axisy.max}else if(y2>=y1&&y2>axisy.max&&y1<=axisy.max){x2=(axisy.max-y1)/(y2-y1)*(x2-x1)+x1;y2=axisy.max}if(x1!==x1old){ctx.lineTo(axisx.p2c(x1old),axisy.p2c(y1))}ctx.lineTo(axisx.p2c(x1),axisy.p2c(y1));ctx.lineTo(axisx.p2c(x2),axisy.p2c(y2));if(x2!==x2old){ctx.lineTo(axisx.p2c(x2),axisy.p2c(y2));ctx.lineTo(axisx.p2c(x2old),axisy.p2c(y2))}}}function drawSeriesLines(series,ctx,plotOffset,plotWidth,plotHeight,drawSymbol,getColorOrGradient){ctx.save();ctx.translate(plotOffset.left,plotOffset.top);ctx.lineJoin="round";if(series.lines.dashes&&ctx.setLineDash){ctx.setLineDash(series.lines.dashes)}var datapoints={format:series.datapoints.format,points:series.datapoints.points,pointsize:series.datapoints.pointsize};if(series.decimate){datapoints.points=series.decimate(series,series.xaxis.min,series.xaxis.max,plotWidth,series.yaxis.min,series.yaxis.max,plotHeight)}var lw=series.lines.lineWidth;ctx.lineWidth=lw;ctx.strokeStyle=series.color;var fillStyle=getFillStyle(series.lines,series.color,0,plotHeight,getColorOrGradient);if(fillStyle){ctx.fillStyle=fillStyle;plotLineArea(datapoints,series.xaxis,series.yaxis,series.lines.fillTowards||0,ctx,series.lines.steps)}if(lw>0){plotLine(datapoints,0,0,series.xaxis,series.yaxis,ctx,series.lines.steps)}ctx.restore()}function drawSeriesPoints(series,ctx,plotOffset,plotWidth,plotHeight,drawSymbol,getColorOrGradient){function drawCircle(ctx,x,y,radius,shadow,fill){ctx.moveTo(x+radius,y);ctx.arc(x,y,radius,0,shadow?Math.PI:Math.PI*2,false)}drawCircle.fill=true;function plotPoints(datapoints,radius,fill,offset,shadow,axisx,axisy,drawSymbolFn){var points=datapoints.points,ps=datapoints.pointsize;ctx.beginPath();for(var i=0;i<points.length;i+=ps){var x=points[i],y=points[i+1];if(x==null||x<axisx.min||x>axisx.max||y<axisy.min||y>axisy.max){continue}x=axisx.p2c(x);y=axisy.p2c(y)+offset;drawSymbolFn(ctx,x,y,radius,shadow,fill)}if(drawSymbolFn.fill&&!shadow){ctx.fill()}ctx.stroke()}ctx.save();ctx.translate(plotOffset.left,plotOffset.top);var datapoints={format:series.datapoints.format,points:series.datapoints.points,pointsize:series.datapoints.pointsize};if(series.decimatePoints){datapoints.points=series.decimatePoints(series,series.xaxis.min,series.xaxis.max,plotWidth,series.yaxis.min,series.yaxis.max,plotHeight)}var lw=series.points.lineWidth,radius=series.points.radius,symbol=series.points.symbol,drawSymbolFn;if(symbol==="circle"){drawSymbolFn=drawCircle}else if(typeof symbol==="string"&&drawSymbol&&drawSymbol[symbol]){drawSymbolFn=drawSymbol[symbol]}else if(typeof drawSymbol==="function"){drawSymbolFn=drawSymbol}if(lw===0){lw=1e-4}ctx.lineWidth=lw;ctx.fillStyle=getFillStyle(series.points,series.color,null,null,getColorOrGradient);ctx.strokeStyle=series.color;plotPoints(datapoints,radius,true,0,false,series.xaxis,series.yaxis,drawSymbolFn);ctx.restore()}function drawBar(x,y,b,barLeft,barRight,fillStyleCallback,axisx,axisy,c,horizontal,lineWidth){var left=x+barLeft,right=x+barRight,bottom=b,top=y,drawLeft,drawRight,drawTop,drawBottom=false,tmp;drawLeft=drawRight=drawTop=true;if(horizontal){drawBottom=drawRight=drawTop=true;drawLeft=false;left=b;right=x;top=y+barLeft;bottom=y+barRight;if(right<left){tmp=right;right=left;left=tmp;drawLeft=true;drawRight=false}}else{drawLeft=drawRight=drawTop=true;drawBottom=false;left=x+barLeft;right=x+barRight;bottom=b;top=y;if(top<bottom){tmp=top;top=bottom;bottom=tmp;drawBottom=true;drawTop=false}}if(right<axisx.min||left>axisx.max||top<axisy.min||bottom>axisy.max){return}if(left<axisx.min){left=axisx.min;drawLeft=false}if(right>axisx.max){right=axisx.max;drawRight=false}if(bottom<axisy.min){bottom=axisy.min;drawBottom=false}if(top>axisy.max){top=axisy.max;drawTop=false}left=axisx.p2c(left);bottom=axisy.p2c(bottom);right=axisx.p2c(right);top=axisy.p2c(top);if(fillStyleCallback){c.fillStyle=fillStyleCallback(bottom,top);c.fillRect(left,top,right-left,bottom-top)}if(lineWidth>0&&(drawLeft||drawRight||drawTop||drawBottom)){c.beginPath();c.moveTo(left,bottom);if(drawLeft){c.lineTo(left,top)}else{c.moveTo(left,top)}if(drawTop){c.lineTo(right,top)}else{c.moveTo(right,top)}if(drawRight){c.lineTo(right,bottom)}else{c.moveTo(right,bottom)}if(drawBottom){c.lineTo(left,bottom)}else{c.moveTo(left,bottom)}c.stroke()}}function drawSeriesBars(series,ctx,plotOffset,plotWidth,plotHeight,drawSymbol,getColorOrGradient){function plotBars(datapoints,barLeft,barRight,fillStyleCallback,axisx,axisy){var points=datapoints.points,ps=datapoints.pointsize,fillTowards=series.bars.fillTowards||0,defaultBottom=fillTowards>axisy.min?Math.min(axisy.max,fillTowards):axisy.min;for(var i=0;i<points.length;i+=ps){if(points[i]==null){continue}var bottom=ps===3?points[i+2]:defaultBottom;drawBar(points[i],points[i+1],bottom,barLeft,barRight,fillStyleCallback,axisx,axisy,ctx,series.bars.horizontal,series.bars.lineWidth)}}ctx.save();ctx.translate(plotOffset.left,plotOffset.top);var datapoints={format:series.datapoints.format,points:series.datapoints.points,pointsize:series.datapoints.pointsize};if(series.decimate){datapoints.points=series.decimate(series,series.xaxis.min,series.xaxis.max,plotWidth)}ctx.lineWidth=series.bars.lineWidth;ctx.strokeStyle=series.color;var barLeft;var barWidth=series.bars.barWidth[0]||series.bars.barWidth;switch(series.bars.align){case"left":barLeft=0;break;case"right":barLeft=-barWidth;break;default:barLeft=-barWidth/2}var fillStyleCallback=series.bars.fill?function(bottom,top){return getFillStyle(series.bars,series.color,bottom,top,getColorOrGradient)}:null;plotBars(datapoints,barLeft,barLeft+barWidth,fillStyleCallback,series.xaxis,series.yaxis);ctx.restore()}function getFillStyle(filloptions,seriesColor,bottom,top,getColorOrGradient){var fill=filloptions.fill;if(!fill){return null}if(filloptions.fillColor){return getColorOrGradient(filloptions.fillColor,bottom,top,seriesColor)}var c=$.color.parse(seriesColor);c.a=typeof fill==="number"?fill:.4;c.normalize();return c.toString()}this.drawSeriesLines=drawSeriesLines;this.drawSeriesPoints=drawSeriesPoints;this.drawSeriesBars=drawSeriesBars;this.drawBar=drawBar}$.plot.drawSeries=new DrawSeries})(jQuery);(function($){"use strict";$.plot.uiConstants={SNAPPING_CONSTANT:20,PANHINT_LENGTH_CONSTANT:10,MINOR_TICKS_COUNT_CONSTANT:4,TICK_LENGTH_CONSTANT:10,ZOOM_DISTANCE_MARGIN:25}})(jQuery);(function($){"use strict";var options={zoom:{interactive:false,active:false,amount:1.5},pan:{interactive:false,active:false,cursor:"move",frameRate:60,mode:"smart"},recenter:{interactive:true},xaxis:{axisZoom:true,plotZoom:true,axisPan:true,plotPan:true,panRange:[undefined,undefined],zoomRange:[undefined,undefined]},yaxis:{axisZoom:true,plotZoom:true,axisPan:true,plotPan:true,panRange:[undefined,undefined],zoomRange:[undefined,undefined]}};var saturated=$.plot.saturated;var browser=$.plot.browser;var SNAPPING_CONSTANT=$.plot.uiConstants.SNAPPING_CONSTANT;var PANHINT_LENGTH_CONSTANT=$.plot.uiConstants.PANHINT_LENGTH_CONSTANT;function init(plot){plot.hooks.processOptions.push(initNevigation)}function initNevigation(plot,options){var panAxes=null;var canDrag=false;var useManualPan=options.pan.mode==="manual",smartPanLock=options.pan.mode==="smartLock",useSmartPan=smartPanLock||options.pan.mode==="smart";function onZoomClick(e,zoomOut,amount){var page=browser.getPageXY(e);var c=plot.offset();c.left=page.X-c.left;c.top=page.Y-c.top;var ec=plot.getPlaceholder().offset();ec.left=page.X-ec.left;ec.top=page.Y-ec.top;var axes=plot.getXAxes().concat(plot.getYAxes()).filter(function(axis){var box=axis.box;if(box!==undefined){return ec.left>box.left&&ec.left<box.left+box.width&&ec.top>box.top&&ec.top<box.top+box.height}});if(axes.length===0){axes=undefined}if(zoomOut){plot.zoomOut({center:c,axes:axes,amount:amount})}else{plot.zoom({center:c,axes:axes,amount:amount})}}var prevCursor="default",panHint=null,panTimeout=null,plotState,prevDragPosition={x:0,y:0},isPanAction=false;function onMouseWheel(e,delta){var maxAbsoluteDeltaOnMac=1,isMacScroll=Math.abs(e.originalEvent.deltaY)<=maxAbsoluteDeltaOnMac,defaultNonMacScrollAmount=null,macMagicRatio=50,amount=isMacScroll?1+Math.abs(e.originalEvent.deltaY)/macMagicRatio:defaultNonMacScrollAmount;if(isPanAction){onDragEnd(e)}if(plot.getOptions().zoom.active){e.preventDefault();onZoomClick(e,delta<0,amount);return false}}plot.navigationState=function(startPageX,startPageY){var axes=this.getAxes();var result={};Object.keys(axes).forEach(function(axisName){var axis=axes[axisName];result[axisName]={navigationOffset:{below:axis.options.offset.below||0,above:axis.options.offset.above||0},axisMin:axis.min,axisMax:axis.max,diagMode:false}});result.startPageX=startPageX||0;result.startPageY=startPageY||0;return result};function onMouseDown(e){canDrag=true}function onMouseUp(e){canDrag=false}function isLeftMouseButtonPressed(e){return e.button===0}function onDragStart(e){if(!canDrag||!isLeftMouseButtonPressed(e)){return false}isPanAction=true;var page=browser.getPageXY(e);var ec=plot.getPlaceholder().offset();ec.left=page.X-ec.left;ec.top=page.Y-ec.top;panAxes=plot.getXAxes().concat(plot.getYAxes()).filter(function(axis){var box=axis.box;if(box!==undefined){return ec.left>box.left&&ec.left<box.left+box.width&&ec.top>box.top&&ec.top<box.top+box.height}});if(panAxes.length===0){panAxes=undefined}var c=plot.getPlaceholder().css("cursor");if(c){prevCursor=c}plot.getPlaceholder().css("cursor",plot.getOptions().pan.cursor);if(useSmartPan){plotState=plot.navigationState(page.X,page.Y)}else if(useManualPan){prevDragPosition.x=page.X;prevDragPosition.y=page.Y}}function onDrag(e){if(!isPanAction){return}var page=browser.getPageXY(e);var frameRate=plot.getOptions().pan.frameRate;if(frameRate===-1){if(useSmartPan){plot.smartPan({x:plotState.startPageX-page.X,y:plotState.startPageY-page.Y},plotState,panAxes,false,smartPanLock)}else if(useManualPan){plot.pan({left:prevDragPosition.x-page.X,top:prevDragPosition.y-page.Y,axes:panAxes});prevDragPosition.x=page.X;prevDragPosition.y=page.Y}return}if(panTimeout||!frameRate)return;panTimeout=setTimeout(function(){if(useSmartPan){plot.smartPan({x:plotState.startPageX-page.X,y:plotState.startPageY-page.Y},plotState,panAxes,false,smartPanLock)}else if(useManualPan){plot.pan({left:prevDragPosition.x-page.X,top:prevDragPosition.y-page.Y,axes:panAxes});prevDragPosition.x=page.X;prevDragPosition.y=page.Y}panTimeout=null},1/frameRate*1e3)}function onDragEnd(e){if(!isPanAction){return}if(panTimeout){clearTimeout(panTimeout);panTimeout=null}isPanAction=false;var page=browser.getPageXY(e);plot.getPlaceholder().css("cursor",prevCursor);if(useSmartPan){plot.smartPan({x:plotState.startPageX-page.X,y:plotState.startPageY-page.Y},plotState,panAxes,false,smartPanLock);plot.smartPan.end()}else if(useManualPan){plot.pan({left:prevDragPosition.x-page.X,top:prevDragPosition.y-page.Y,axes:panAxes});prevDragPosition.x=0;prevDragPosition.y=0}}function onDblClick(e){plot.activate();var o=plot.getOptions();if(!o.recenter.interactive){return}var axes=plot.getTouchedAxis(e.clientX,e.clientY),event;plot.recenter({axes:axes[0]?axes:null});if(axes[0]){event=new $.Event("re-center",{detail:{axisTouched:axes[0]}})}else{event=new $.Event("re-center",{detail:e})}plot.getPlaceholder().trigger(event)}function onClick(e){plot.activate();if(isPanAction){onDragEnd(e)}return false}plot.activate=function(){var o=plot.getOptions();if(!o.pan.active||!o.zoom.active){o.pan.active=true;o.zoom.active=true;plot.getPlaceholder().trigger("plotactivated",[plot])}};function bindEvents(plot,eventHolder){var o=plot.getOptions();if(o.zoom.interactive){eventHolder.mousewheel(onMouseWheel)}if(o.pan.interactive){plot.addEventHandler("dragstart",onDragStart,eventHolder,0);plot.addEventHandler("drag",onDrag,eventHolder,0);plot.addEventHandler("dragend",onDragEnd,eventHolder,0);eventHolder.bind("mousedown",onMouseDown);eventHolder.bind("mouseup",onMouseUp)}eventHolder.dblclick(onDblClick);eventHolder.click(onClick)}plot.zoomOut=function(args){if(!args){args={}}if(!args.amount){args.amount=plot.getOptions().zoom.amount}args.amount=1/args.amount;plot.zoom(args)};plot.zoom=function(args){if(!args){args={}}var c=args.center,amount=args.amount||plot.getOptions().zoom.amount,w=plot.width(),h=plot.height(),axes=args.axes||plot.getAxes();if(!c){c={left:w/2,top:h/2}}var xf=c.left/w,yf=c.top/h,minmax={x:{min:c.left-xf*w/amount,max:c.left+(1-xf)*w/amount},y:{min:c.top-yf*h/amount,max:c.top+(1-yf)*h/amount}};for(var key in axes){if(!axes.hasOwnProperty(key)){continue}var axis=axes[key],opts=axis.options,min=minmax[axis.direction].min,max=minmax[axis.direction].max,navigationOffset=axis.options.offset;if(!opts.axisZoom&&args.axes||!args.axes&&!opts.plotZoom){continue}min=$.plot.saturated.saturate(axis.c2p(min));max=$.plot.saturated.saturate(axis.c2p(max));if(min>max){var tmp=min;min=max;max=tmp}if(opts.zoomRange){if(max-min<opts.zoomRange[0]){continue}if(max-min>opts.zoomRange[1]){continue}}var offsetBelow=$.plot.saturated.saturate(navigationOffset.below-(axis.min-min));var offsetAbove=$.plot.saturated.saturate(navigationOffset.above-(axis.max-max));opts.offset={below:offsetBelow,above:offsetAbove}}plot.setupGrid(true);plot.draw();if(!args.preventEvent){plot.getPlaceholder().trigger("plotzoom",[plot,args])}};plot.pan=function(args){var delta={x:+args.left,y:+args.top};if(isNaN(delta.x))delta.x=0;if(isNaN(delta.y))delta.y=0;$.each(args.axes||plot.getAxes(),function(_,axis){var opts=axis.options,d=delta[axis.direction];if(!opts.axisPan&&args.axes||!opts.plotPan&&!args.axes){return}var minD=axis.p2c(opts.panRange[0])-axis.p2c(axis.min);var maxD=axis.p2c(opts.panRange[1])-axis.p2c(axis.max);if(opts.panRange[0]!==undefined&&d>=maxD)d=maxD;if(opts.panRange[1]!==undefined&&d<=minD)d=minD;if(d!==0){var navigationOffsetBelow=saturated.saturate(axis.c2p(axis.p2c(axis.min)+d)-axis.c2p(axis.p2c(axis.min))),navigationOffsetAbove=saturated.saturate(axis.c2p(axis.p2c(axis.max)+d)-axis.c2p(axis.p2c(axis.max)));if(!isFinite(navigationOffsetBelow)){navigationOffsetBelow=0}if(!isFinite(navigationOffsetAbove)){navigationOffsetAbove=0}opts.offset={below:saturated.saturate(navigationOffsetBelow+(opts.offset.below||0)),above:saturated.saturate(navigationOffsetAbove+(opts.offset.above||0))}}});plot.setupGrid(true);plot.draw();if(!args.preventEvent){plot.getPlaceholder().trigger("plotpan",[plot,args])}};plot.recenter=function(args){$.each(args.axes||plot.getAxes(),function(_,axis){if(args.axes){if(this.direction==="x"){axis.options.offset={below:0}}else if(this.direction==="y"){axis.options.offset={above:0}}}else{axis.options.offset={below:0,above:0}}});plot.setupGrid(true);plot.draw()};var shouldSnap=function shouldSnap(delta){return Math.abs(delta.y)<SNAPPING_CONSTANT&&Math.abs(delta.x)>=SNAPPING_CONSTANT||Math.abs(delta.x)<SNAPPING_CONSTANT&&Math.abs(delta.y)>=SNAPPING_CONSTANT};var adjustDeltaToSnap=function adjustDeltaToSnap(delta){if(Math.abs(delta.x)<SNAPPING_CONSTANT&&Math.abs(delta.y)>=SNAPPING_CONSTANT){return{x:0,y:delta.y}}if(Math.abs(delta.y)<SNAPPING_CONSTANT&&Math.abs(delta.x)>=SNAPPING_CONSTANT){return{x:delta.x,y:0}}return delta};var lockedDirection=null;var lockDeltaDirection=function lockDeltaDirection(delta){if(!lockedDirection&&Math.max(Math.abs(delta.x),Math.abs(delta.y))>=SNAPPING_CONSTANT){lockedDirection=Math.abs(delta.x)<Math.abs(delta.y)?"y":"x"}switch(lockedDirection){case"x":return{x:delta.x,y:0};case"y":return{x:0,y:delta.y};default:return{x:0,y:0}}};var isDiagonalMode=function isDiagonalMode(delta){if(Math.abs(delta.x)>0&&Math.abs(delta.y)>0){return true}return false};var restoreAxisOffset=function restoreAxisOffset(axes,initialState,delta){var axis;Object.keys(axes).forEach(function(axisName){axis=axes[axisName];if(delta[axis.direction]===0){axis.options.offset.below=initialState[axisName].navigationOffset.below;axis.options.offset.above=initialState[axisName].navigationOffset.above}})};var prevDelta={x:0,y:0};plot.smartPan=function(delta,initialState,panAxes,preventEvent,smartLock){var snap=smartLock?true:shouldSnap(delta),axes=plot.getAxes(),opts;delta=smartLock?lockDeltaDirection(delta):adjustDeltaToSnap(delta);if(isDiagonalMode(delta)){initialState.diagMode=true}if(snap&&initialState.diagMode===true){initialState.diagMode=false;restoreAxisOffset(axes,initialState,delta)}if(snap){panHint={start:{x:initialState.startPageX-plot.offset().left+plot.getPlotOffset().left,y:initialState.startPageY-plot.offset().top+plot.getPlotOffset().top},end:{x:initialState.startPageX-delta.x-plot.offset().left+plot.getPlotOffset().left,y:initialState.startPageY-delta.y-plot.offset().top+plot.getPlotOffset().top}}}else{panHint={start:{x:initialState.startPageX-plot.offset().left+plot.getPlotOffset().left,y:initialState.startPageY-plot.offset().top+plot.getPlotOffset().top},end:false}}if(isNaN(delta.x))delta.x=0;if(isNaN(delta.y))delta.y=0;if(panAxes){axes=panAxes}var axis,axisMin,axisMax,p,d;Object.keys(axes).forEach(function(axisName){axis=axes[axisName];axisMin=axis.min;axisMax=axis.max;opts=axis.options;d=delta[axis.direction];p=prevDelta[axis.direction];if(!opts.axisPan&&panAxes||!panAxes&&!opts.plotPan){return}var minD=p+axis.p2c(opts.panRange[0])-axis.p2c(axisMin);var maxD=p+axis.p2c(opts.panRange[1])-axis.p2c(axisMax);if(opts.panRange[0]!==undefined&&d>=maxD)d=maxD;if(opts.panRange[1]!==undefined&&d<=minD)d=minD;if(d!==0){var navigationOffsetBelow=saturated.saturate(axis.c2p(axis.p2c(axisMin)-(p-d))-axis.c2p(axis.p2c(axisMin))),navigationOffsetAbove=saturated.saturate(axis.c2p(axis.p2c(axisMax)-(p-d))-axis.c2p(axis.p2c(axisMax)));if(!isFinite(navigationOffsetBelow)){navigationOffsetBelow=0}if(!isFinite(navigationOffsetAbove)){navigationOffsetAbove=0}axis.options.offset.below=saturated.saturate(navigationOffsetBelow+(axis.options.offset.below||0));axis.options.offset.above=saturated.saturate(navigationOffsetAbove+(axis.options.offset.above||0))}});prevDelta=delta;plot.setupGrid(true);plot.draw();if(!preventEvent){plot.getPlaceholder().trigger("plotpan",[plot,delta,panAxes,initialState])}};plot.smartPan.end=function(){panHint=null;lockedDirection=null;prevDelta={x:0,y:0};plot.triggerRedrawOverlay()};function shutdown(plot,eventHolder){eventHolder.unbind("mousewheel",onMouseWheel);eventHolder.unbind("mousedown",onMouseDown);eventHolder.unbind("mouseup",onMouseUp);eventHolder.unbind("dragstart",onDragStart);eventHolder.unbind("drag",onDrag);eventHolder.unbind("dragend",onDragEnd);eventHolder.unbind("dblclick",onDblClick);eventHolder.unbind("click",onClick);if(panTimeout)clearTimeout(panTimeout)}function drawOverlay(plot,ctx){if(panHint){ctx.strokeStyle="rgba(96, 160, 208, 0.7)";ctx.lineWidth=2;ctx.lineJoin="round";var startx=Math.round(panHint.start.x),starty=Math.round(panHint.start.y),endx,endy;if(panAxes){if(panAxes[0].direction==="x"){endy=Math.round(panHint.start.y);endx=Math.round(panHint.end.x)}else if(panAxes[0].direction==="y"){endx=Math.round(panHint.start.x);endy=Math.round(panHint.end.y)}}else{endx=Math.round(panHint.end.x);endy=Math.round(panHint.end.y)}ctx.beginPath();if(panHint.end===false){ctx.moveTo(startx,starty-PANHINT_LENGTH_CONSTANT);ctx.lineTo(startx,starty+PANHINT_LENGTH_CONSTANT);ctx.moveTo(startx+PANHINT_LENGTH_CONSTANT,starty);ctx.lineTo(startx-PANHINT_LENGTH_CONSTANT,starty)}else{var dirX=starty===endy;ctx.moveTo(startx-(dirX?0:PANHINT_LENGTH_CONSTANT),starty-(dirX?PANHINT_LENGTH_CONSTANT:0));ctx.lineTo(startx+(dirX?0:PANHINT_LENGTH_CONSTANT),starty+(dirX?PANHINT_LENGTH_CONSTANT:0));ctx.moveTo(startx,starty);ctx.lineTo(endx,endy);ctx.moveTo(endx-(dirX?0:PANHINT_LENGTH_CONSTANT),endy-(dirX?PANHINT_LENGTH_CONSTANT:0));ctx.lineTo(endx+(dirX?0:PANHINT_LENGTH_CONSTANT),endy+(dirX?PANHINT_LENGTH_CONSTANT:0))}ctx.stroke()}}plot.getTouchedAxis=function(touchPointX,touchPointY){var ec=plot.getPlaceholder().offset();ec.left=touchPointX-ec.left;ec.top=touchPointY-ec.top;var axis=plot.getXAxes().concat(plot.getYAxes()).filter(function(axis){var box=axis.box;if(box!==undefined){return ec.left>box.left&&ec.left<box.left+box.width&&ec.top>box.top&&ec.top<box.top+box.height}});return axis};plot.hooks.drawOverlay.push(drawOverlay);plot.hooks.bindEvents.push(bindEvents);plot.hooks.shutdown.push(shutdown)}$.plot.plugins.push({init:init,options:options,name:"navigate",version:"1.3"})})(jQuery);(function($){"use strict";var options={zoom:{enableTouch:false},pan:{enableTouch:false,touchMode:"manual"},recenter:{enableTouch:true}};var ZOOM_DISTANCE_MARGIN=$.plot.uiConstants.ZOOM_DISTANCE_MARGIN;function init(plot){plot.hooks.processOptions.push(initTouchNavigation)}function initTouchNavigation(plot,options){var gestureState={zoomEnable:false,prevDistance:null,prevTapTime:0,prevPanPosition:{x:0,y:0},prevTapPosition:{x:0,y:0}},navigationState={prevTouchedAxis:"none",currentTouchedAxis:"none",touchedAxis:null,navigationConstraint:"unconstrained",initialState:null},useManualPan=options.pan.interactive&&options.pan.touchMode==="manual",smartPanLock=options.pan.touchMode==="smartLock",useSmartPan=options.pan.interactive&&(smartPanLock||options.pan.touchMode==="smart"),pan,pinch,doubleTap;function bindEvents(plot,eventHolder){var o=plot.getOptions();if(o.zoom.interactive&&o.zoom.enableTouch){eventHolder[0].addEventListener("pinchstart",pinch.start,false);eventHolder[0].addEventListener("pinchdrag",pinch.drag,false);eventHolder[0].addEventListener("pinchend",pinch.end,false)}if(o.pan.interactive&&o.pan.enableTouch){eventHolder[0].addEventListener("panstart",pan.start,false);eventHolder[0].addEventListener("pandrag",pan.drag,false);eventHolder[0].addEventListener("panend",pan.end,false)}if(o.recenter.interactive&&o.recenter.enableTouch){eventHolder[0].addEventListener("doubletap",doubleTap.recenterPlot,false)}}function shutdown(plot,eventHolder){eventHolder[0].removeEventListener("panstart",pan.start);eventHolder[0].removeEventListener("pandrag",pan.drag);eventHolder[0].removeEventListener("panend",pan.end);eventHolder[0].removeEventListener("pinchstart",pinch.start);eventHolder[0].removeEventListener("pinchdrag",pinch.drag);eventHolder[0].removeEventListener("pinchend",pinch.end);eventHolder[0].removeEventListener("doubletap",doubleTap.recenterPlot)}pan={start:function start(e){presetNavigationState(e,"pan",gestureState);updateData(e,"pan",gestureState,navigationState);if(useSmartPan){var point=getPoint(e,"pan");navigationState.initialState=plot.navigationState(point.x,point.y)}},drag:function drag(e){presetNavigationState(e,"pan",gestureState);if(useSmartPan){var point=getPoint(e,"pan");plot.smartPan({x:navigationState.initialState.startPageX-point.x,y:navigationState.initialState.startPageY-point.y},navigationState.initialState,navigationState.touchedAxis,false,smartPanLock)}else if(useManualPan){plot.pan({left:-delta(e,"pan",gestureState).x,top:-delta(e,"pan",gestureState).y,axes:navigationState.touchedAxis});updatePrevPanPosition(e,"pan",gestureState,navigationState)}},end:function end(e){presetNavigationState(e,"pan",gestureState);if(useSmartPan){plot.smartPan.end()}if(wasPinchEvent(e,gestureState)){updateprevPanPosition(e,"pan",gestureState,navigationState)}}};var pinchDragTimeout;pinch={start:function start(e){if(pinchDragTimeout){clearTimeout(pinchDragTimeout);pinchDragTimeout=null}presetNavigationState(e,"pinch",gestureState);setPrevDistance(e,gestureState);updateData(e,"pinch",gestureState,navigationState)},drag:function drag(e){if(pinchDragTimeout){return}pinchDragTimeout=setTimeout(function(){presetNavigationState(e,"pinch",gestureState);plot.pan({left:-delta(e,"pinch",gestureState).x,top:-delta(e,"pinch",gestureState).y,axes:navigationState.touchedAxis});updatePrevPanPosition(e,"pinch",gestureState,navigationState);var dist=pinchDistance(e);if(gestureState.zoomEnable||Math.abs(dist-gestureState.prevDistance)>ZOOM_DISTANCE_MARGIN){zoomPlot(plot,e,gestureState,navigationState);gestureState.zoomEnable=true}pinchDragTimeout=null},1e3/60)},end:function end(e){if(pinchDragTimeout){clearTimeout(pinchDragTimeout);pinchDragTimeout=null}presetNavigationState(e,"pinch",gestureState);gestureState.prevDistance=null}};doubleTap={recenterPlot:function recenterPlot(e){if(e&&e.detail&&e.detail.type==="touchstart"){recenterPlotOnDoubleTap(plot,e,gestureState,navigationState)}}};if(options.pan.enableTouch===true||options.zoom.enableTouch===true){plot.hooks.bindEvents.push(bindEvents);plot.hooks.shutdown.push(shutdown)}function presetNavigationState(e,gesture,gestureState){navigationState.touchedAxis=getAxis(plot,e,gesture,navigationState);if(noAxisTouched(navigationState)){navigationState.navigationConstraint="unconstrained"}else{navigationState.navigationConstraint="axisConstrained"}}}$.plot.plugins.push({init:init,options:options,name:"navigateTouch",version:"0.3"});function recenterPlotOnDoubleTap(plot,e,gestureState,navigationState){checkAxesForDoubleTap(plot,e,navigationState);if(navigationState.currentTouchedAxis==="x"&&navigationState.prevTouchedAxis==="x"||navigationState.currentTouchedAxis==="y"&&navigationState.prevTouchedAxis==="y"||navigationState.currentTouchedAxis==="none"&&navigationState.prevTouchedAxis==="none"){var event;plot.recenter({axes:navigationState.touchedAxis});if(navigationState.touchedAxis){event=new $.Event("re-center",{detail:{axisTouched:navigationState.touchedAxis}})}else{event=new $.Event("re-center",{detail:e})}plot.getPlaceholder().trigger(event)}}function checkAxesForDoubleTap(plot,e,navigationState){var axis=plot.getTouchedAxis(e.detail.firstTouch.x,e.detail.firstTouch.y);if(axis[0]!==undefined){navigationState.prevTouchedAxis=axis[0].direction}axis=plot.getTouchedAxis(e.detail.secondTouch.x,e.detail.secondTouch.y);if(axis[0]!==undefined){navigationState.touchedAxis=axis;navigationState.currentTouchedAxis=axis[0].direction}if(noAxisTouched(navigationState)){navigationState.touchedAxis=null;navigationState.prevTouchedAxis="none";navigationState.currentTouchedAxis="none"}}function zoomPlot(plot,e,gestureState,navigationState){var offset=plot.offset(),center={left:0,top:0},zoomAmount=pinchDistance(e)/gestureState.prevDistance,dist=pinchDistance(e);center.left=getPoint(e,"pinch").x-offset.left;center.top=getPoint(e,"pinch").y-offset.top;plot.zoom({center:center,amount:zoomAmount,axes:navigationState.touchedAxis});gestureState.prevDistance=dist}function wasPinchEvent(e,gestureState){return gestureState.zoomEnable&&e.detail.touches.length===1}function getAxis(plot,e,gesture,navigationState){if(e.type==="pinchstart"){var axisTouch1=plot.getTouchedAxis(e.detail.touches[0].pageX,e.detail.touches[0].pageY);var axisTouch2=plot.getTouchedAxis(e.detail.touches[1].pageX,e.detail.touches[1].pageY);if(axisTouch1.length===axisTouch2.length&&axisTouch1.toString()===axisTouch2.toString()){return axisTouch1}}else if(e.type==="panstart"){return plot.getTouchedAxis(e.detail.touches[0].pageX,e.detail.touches[0].pageY)}else if(e.type==="pinchend"){return plot.getTouchedAxis(e.detail.touches[0].pageX,e.detail.touches[0].pageY)}else{return navigationState.touchedAxis}}function noAxisTouched(navigationState){return!navigationState.touchedAxis||navigationState.touchedAxis.length===0}function setPrevDistance(e,gestureState){gestureState.prevDistance=pinchDistance(e)}function updateData(e,gesture,gestureState,navigationState){var axisDir,point=getPoint(e,gesture);switch(navigationState.navigationConstraint){case"unconstrained":navigationState.touchedAxis=null;gestureState.prevTapPosition={x:gestureState.prevPanPosition.x,y:gestureState.prevPanPosition.y};gestureState.prevPanPosition={x:point.x,y:point.y};break;case"axisConstrained":axisDir=navigationState.touchedAxis[0].direction;navigationState.currentTouchedAxis=axisDir;gestureState.prevTapPosition[axisDir]=gestureState.prevPanPosition[axisDir];gestureState.prevPanPosition[axisDir]=point[axisDir];break;default:break}}function distance(x1,y1,x2,y2){return Math.sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2))}function pinchDistance(e){var t1=e.detail.touches[0],t2=e.detail.touches[1];return distance(t1.pageX,t1.pageY,t2.pageX,t2.pageY)}function updatePrevPanPosition(e,gesture,gestureState,navigationState){var point=getPoint(e,gesture);switch(navigationState.navigationConstraint){case"unconstrained":gestureState.prevPanPosition.x=point.x;gestureState.prevPanPosition.y=point.y;break;case"axisConstrained":gestureState.prevPanPosition[navigationState.currentTouchedAxis]=point[navigationState.currentTouchedAxis];break;default:break}}function delta(e,gesture,gestureState){var point=getPoint(e,gesture);return{x:point.x-gestureState.prevPanPosition.x,y:point.y-gestureState.prevPanPosition.y}}function getPoint(e,gesture){if(gesture==="pinch"){return{x:(e.detail.touches[0].pageX+e.detail.touches[1].pageX)/2,y:(e.detail.touches[0].pageY+e.detail.touches[1].pageY)/2}}else{return{x:e.detail.touches[0].pageX,y:e.detail.touches[0].pageY}}}})(jQuery);(function($){"use strict";var options={grid:{hoverable:false,clickable:false}};var browser=$.plot.browser;var eventType={click:"click",hover:"hover"};function init(plot){var lastMouseMoveEvent;var highlights=[];function bindEvents(plot,eventHolder){var o=plot.getOptions();if(o.grid.hoverable||o.grid.clickable){eventHolder[0].addEventListener("touchevent",triggerCleanupEvent,false);eventHolder[0].addEventListener("tap",generatePlothoverEvent,false)}if(o.grid.clickable){eventHolder.bind("click",onClick)}if(o.grid.hoverable){eventHolder.bind("mousemove",onMouseMove);eventHolder.bind("mouseleave",onMouseLeave)}}function shutdown(plot,eventHolder){eventHolder[0].removeEventListener("tap",generatePlothoverEvent);eventHolder[0].removeEventListener("touchevent",triggerCleanupEvent);eventHolder.unbind("mousemove",onMouseMove);eventHolder.unbind("mouseleave",onMouseLeave);eventHolder.unbind("click",onClick);highlights=[]}function generatePlothoverEvent(e){var o=plot.getOptions(),newEvent=new CustomEvent("mouseevent");newEvent.pageX=e.detail.changedTouches[0].pageX;newEvent.pageY=e.detail.changedTouches[0].pageY;newEvent.clientX=e.detail.changedTouches[0].clientX;newEvent.clientY=e.detail.changedTouches[0].clientY;if(o.grid.hoverable){doTriggerClickHoverEvent(newEvent,eventType.hover,30)}return false}function doTriggerClickHoverEvent(event,eventType,searchDistance){var series=plot.getData();if(event!==undefined&&series.length>0&&series[0].xaxis.c2p!==undefined&&series[0].yaxis.c2p!==undefined){var eventToTrigger="plot"+eventType;var seriesFlag=eventType+"able";triggerClickHoverEvent(eventToTrigger,event,function(i){return series[i][seriesFlag]!==false},searchDistance)}}function onMouseMove(e){lastMouseMoveEvent=e;plot.getPlaceholder()[0].lastMouseMoveEvent=e;doTriggerClickHoverEvent(e,eventType.hover)}function onMouseLeave(e){lastMouseMoveEvent=undefined;plot.getPlaceholder()[0].lastMouseMoveEvent=undefined;triggerClickHoverEvent("plothover",e,function(i){return false})}function onClick(e){doTriggerClickHoverEvent(e,eventType.click)}function triggerCleanupEvent(){plot.unhighlight();plot.getPlaceholder().trigger("plothovercleanup")}function triggerClickHoverEvent(eventname,event,seriesFilter,searchDistance){var options=plot.getOptions(),offset=plot.offset(),page=browser.getPageXY(event),canvasX=page.X-offset.left,canvasY=page.Y-offset.top,pos=plot.c2p({left:canvasX,top:canvasY}),distance=searchDistance!==undefined?searchDistance:options.grid.mouseActiveRadius;pos.pageX=page.X;pos.pageY=page.Y;var items=plot.findNearbyItems(canvasX,canvasY,seriesFilter,distance);var item=items[0];for(var i=1;i<items.length;++i){if(item.distance===undefined||items[i].distance<item.distance){item=items[i]}}if(item){item.pageX=parseInt(item.series.xaxis.p2c(item.datapoint[0])+offset.left,10);item.pageY=parseInt(item.series.yaxis.p2c(item.datapoint[1])+offset.top,10)}else{item=null}if(options.grid.autoHighlight){for(var _i=0;_i<highlights.length;++_i){var h=highlights[_i];if(h.auto===eventname&&!(item&&h.series===item.series&&h.point[0]===item.datapoint[0]&&h.point[1]===item.datapoint[1])||!item){unhighlight(h.series,h.point)}}if(item){highlight(item.series,item.datapoint,eventname)}}plot.getPlaceholder().trigger(eventname,[pos,item,items])}function highlight(s,point,auto){if(typeof s==="number"){s=plot.getData()[s]}if(typeof point==="number"){var ps=s.datapoints.pointsize;point=s.datapoints.points.slice(ps*point,ps*(point+1))}var i=indexOfHighlight(s,point);if(i===-1){highlights.push({series:s,point:point,auto:auto});plot.triggerRedrawOverlay()}else if(!auto){highlights[i].auto=false}}function unhighlight(s,point){if(s==null&&point==null){highlights=[];plot.triggerRedrawOverlay();return}if(typeof s==="number"){s=plot.getData()[s]}if(typeof point==="number"){var ps=s.datapoints.pointsize;point=s.datapoints.points.slice(ps*point,ps*(point+1))}var i=indexOfHighlight(s,point);if(i!==-1){highlights.splice(i,1);plot.triggerRedrawOverlay()}}function indexOfHighlight(s,p){for(var i=0;i<highlights.length;++i){var h=highlights[i];if(h.series===s&&h.point[0]===p[0]&&h.point[1]===p[1]){return i}}return-1}function processDatapoints(){triggerCleanupEvent();doTriggerClickHoverEvent(lastMouseMoveEvent,eventType.hover)}function setupGrid(){doTriggerClickHoverEvent(lastMouseMoveEvent,eventType.hover)}function drawOverlay(plot,octx,overlay){var plotOffset=plot.getPlotOffset(),i,hi;octx.save();octx.translate(plotOffset.left,plotOffset.top);for(i=0;i<highlights.length;++i){hi=highlights[i];if(hi.series.bars.show)drawBarHighlight(hi.series,hi.point,octx);else drawPointHighlight(hi.series,hi.point,octx,plot)}octx.restore()}function drawPointHighlight(series,point,octx,plot){var x=point[0],y=point[1],axisx=series.xaxis,axisy=series.yaxis,highlightColor=typeof series.highlightColor==="string"?series.highlightColor:$.color.parse(series.color).scale("a",.5).toString();if(x<axisx.min||x>axisx.max||y<axisy.min||y>axisy.max){return}var pointRadius=series.points.radius+series.points.lineWidth/2;octx.lineWidth=pointRadius;octx.strokeStyle=highlightColor;var radius=1.5*pointRadius;x=axisx.p2c(x);y=axisy.p2c(y);octx.beginPath();var symbol=series.points.symbol;if(symbol==="circle"){octx.arc(x,y,radius,0,2*Math.PI,false)}else if(typeof symbol==="string"&&plot.drawSymbol&&plot.drawSymbol[symbol]){plot.drawSymbol[symbol](octx,x,y,radius,false)}octx.closePath();octx.stroke()}function drawBarHighlight(series,point,octx){var highlightColor=typeof series.highlightColor==="string"?series.highlightColor:$.color.parse(series.color).scale("a",.5).toString(),fillStyle=highlightColor,barLeft;var barWidth=series.bars.barWidth[0]||series.bars.barWidth;switch(series.bars.align){case"left":barLeft=0;break;case"right":barLeft=-barWidth;break;default:barLeft=-barWidth/2}octx.lineWidth=series.bars.lineWidth;octx.strokeStyle=highlightColor;var fillTowards=series.bars.fillTowards||0,bottom=fillTowards>series.yaxis.min?Math.min(series.yaxis.max,fillTowards):series.yaxis.min;$.plot.drawSeries.drawBar(point[0],point[1],point[2]||bottom,barLeft,barLeft+barWidth,function(){return fillStyle},series.xaxis,series.yaxis,octx,series.bars.horizontal,series.bars.lineWidth)}function initHover(plot,options){plot.highlight=highlight;plot.unhighlight=unhighlight;if(options.grid.hoverable||options.grid.clickable){plot.hooks.drawOverlay.push(drawOverlay);plot.hooks.processDatapoints.push(processDatapoints);plot.hooks.setupGrid.push(setupGrid)}lastMouseMoveEvent=plot.getPlaceholder()[0].lastMouseMoveEvent}plot.hooks.bindEvents.push(bindEvents);plot.hooks.shutdown.push(shutdown);plot.hooks.processOptions.push(initHover)}$.plot.plugins.push({init:init,options:options,name:"hover",version:"0.1"})})(jQuery);(function($){"use strict";var options={propagateSupportedGesture:false};function init(plot){plot.hooks.processOptions.push(initTouchNavigation)}function initTouchNavigation(plot,options){var gestureState={twoTouches:false,currentTapStart:{x:0,y:0},currentTapEnd:{x:0,y:0},prevTap:{x:0,y:0},currentTap:{x:0,y:0},interceptedLongTap:false,isUnsupportedGesture:false,prevTapTime:null,tapStartTime:null,longTapTriggerId:null},maxDistanceBetweenTaps=20,maxIntervalBetweenTaps=500,maxLongTapDistance=20,minLongTapDuration=1500,pressedTapDuration=125,mainEventHolder;function interpretGestures(e){var o=plot.getOptions();if(!o.pan.active&&!o.zoom.active){return}updateOnMultipleTouches(e);mainEventHolder.dispatchEvent(new CustomEvent("touchevent",{detail:e}));if(isPinchEvent(e)){executeAction(e,"pinch")}else{executeAction(e,"pan");if(!wasPinchEvent(e)){if(isDoubleTap(e)){executeAction(e,"doubleTap")}executeAction(e,"tap");executeAction(e,"longTap")}}}function executeAction(e,gesture){switch(gesture){case"pan":pan[e.type](e);break;case"pinch":pinch[e.type](e);break;case"doubleTap":doubleTap.onDoubleTap(e);break;case"longTap":longTap[e.type](e);break;case"tap":tap[e.type](e);break}}function bindEvents(plot,eventHolder){mainEventHolder=eventHolder[0];eventHolder[0].addEventListener("touchstart",interpretGestures,false);eventHolder[0].addEventListener("touchmove",interpretGestures,false);eventHolder[0].addEventListener("touchend",interpretGestures,false)}function shutdown(plot,eventHolder){eventHolder[0].removeEventListener("touchstart",interpretGestures);eventHolder[0].removeEventListener("touchmove",interpretGestures);eventHolder[0].removeEventListener("touchend",interpretGestures);if(gestureState.longTapTriggerId){clearTimeout(gestureState.longTapTriggerId);gestureState.longTapTriggerId=null}}var pan={touchstart:function touchstart(e){updatePrevForDoubleTap();updateCurrentForDoubleTap(e);updateStateForLongTapStart(e);mainEventHolder.dispatchEvent(new CustomEvent("panstart",{detail:e}))},touchmove:function touchmove(e){preventEventBehaviors(e);updateCurrentForDoubleTap(e);updateStateForLongTapEnd(e);if(!gestureState.isUnsupportedGesture){mainEventHolder.dispatchEvent(new CustomEvent("pandrag",{detail:e}))}},touchend:function touchend(e){preventEventBehaviors(e);if(wasPinchEvent(e)){mainEventHolder.dispatchEvent(new CustomEvent("pinchend",{detail:e}));mainEventHolder.dispatchEvent(new CustomEvent("panstart",{detail:e}))}else if(noTouchActive(e)){mainEventHolder.dispatchEvent(new CustomEvent("panend",{detail:e}))}}};var pinch={touchstart:function touchstart(e){mainEventHolder.dispatchEvent(new CustomEvent("pinchstart",{detail:e}))},touchmove:function touchmove(e){preventEventBehaviors(e);gestureState.twoTouches=isPinchEvent(e);if(!gestureState.isUnsupportedGesture){mainEventHolder.dispatchEvent(new CustomEvent("pinchdrag",{detail:e}))}},touchend:function touchend(e){preventEventBehaviors(e)}};var doubleTap={onDoubleTap:function onDoubleTap(e){preventEventBehaviors(e);mainEventHolder.dispatchEvent(new CustomEvent("doubletap",{detail:e}))}};var longTap={touchstart:function touchstart(e){longTap.waitForLongTap(e)},touchmove:function touchmove(e){},touchend:function touchend(e){if(gestureState.longTapTriggerId){clearTimeout(gestureState.longTapTriggerId);gestureState.longTapTriggerId=null}},isLongTap:function isLongTap(e){var currentTime=(new Date).getTime(),tapDuration=currentTime-gestureState.tapStartTime;if(tapDuration>=minLongTapDuration&&!gestureState.interceptedLongTap){if(distance(gestureState.currentTapStart.x,gestureState.currentTapStart.y,gestureState.currentTapEnd.x,gestureState.currentTapEnd.y)<maxLongTapDistance){gestureState.interceptedLongTap=true;return true}}return false},waitForLongTap:function waitForLongTap(e){var longTapTrigger=function longTapTrigger(){if(longTap.isLongTap(e)){mainEventHolder.dispatchEvent(new CustomEvent("longtap",{detail:e}))}gestureState.longTapTriggerId=null};if(!gestureState.longTapTriggerId){gestureState.longTapTriggerId=setTimeout(longTapTrigger,minLongTapDuration)}}};var tap={touchstart:function touchstart(e){gestureState.tapStartTime=(new Date).getTime()},touchmove:function touchmove(e){},touchend:function touchend(e){if(tap.isTap(e)){mainEventHolder.dispatchEvent(new CustomEvent("tap",{detail:e}));preventEventBehaviors(e)}},isTap:function isTap(e){var currentTime=(new Date).getTime(),tapDuration=currentTime-gestureState.tapStartTime;if(tapDuration<=pressedTapDuration){if(distance(gestureState.currentTapStart.x,gestureState.currentTapStart.y,gestureState.currentTapEnd.x,gestureState.currentTapEnd.y)<maxLongTapDistance){return true}}return false}};if(options.pan.enableTouch===true||options.zoom.enableTouch){plot.hooks.bindEvents.push(bindEvents);plot.hooks.shutdown.push(shutdown)}function updatePrevForDoubleTap(){gestureState.prevTap={x:gestureState.currentTap.x,y:gestureState.currentTap.y}}function updateCurrentForDoubleTap(e){gestureState.currentTap={x:e.touches[0].pageX,y:e.touches[0].pageY}}function updateStateForLongTapStart(e){gestureState.tapStartTime=(new Date).getTime();gestureState.interceptedLongTap=false;gestureState.currentTapStart={x:e.touches[0].pageX,y:e.touches[0].pageY};gestureState.currentTapEnd={x:e.touches[0].pageX,y:e.touches[0].pageY}}function updateStateForLongTapEnd(e){gestureState.currentTapEnd={x:e.touches[0].pageX,y:e.touches[0].pageY}}function isDoubleTap(e){var currentTime=(new Date).getTime(),intervalBetweenTaps=currentTime-gestureState.prevTapTime;if(intervalBetweenTaps>=0&&intervalBetweenTaps<maxIntervalBetweenTaps){if(distance(gestureState.prevTap.x,gestureState.prevTap.y,gestureState.currentTap.x,gestureState.currentTap.y)<maxDistanceBetweenTaps){e.firstTouch=gestureState.prevTap;e.secondTouch=gestureState.currentTap;return true}}gestureState.prevTapTime=currentTime;return false}function preventEventBehaviors(e){if(!gestureState.isUnsupportedGesture){e.preventDefault();if(!plot.getOptions().propagateSupportedGesture){e.stopPropagation()}}}function distance(x1,y1,x2,y2){return Math.sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2))}function noTouchActive(e){return e.touches&&e.touches.length===0}function wasPinchEvent(e){return gestureState.twoTouches&&e.touches.length===1}function updateOnMultipleTouches(e){if(e.touches.length>=3){gestureState.isUnsupportedGesture=true}else{gestureState.isUnsupportedGesture=false}}function isPinchEvent(e){if(e.touches&&e.touches.length>=2){if(e.touches[0].target===plot.getEventHolder()&&e.touches[1].target===plot.getEventHolder()){return true}}return false}}$.plot.plugins.push({init:init,options:options,name:"navigateTouch",version:"0.3"})})(jQuery);(function($){var defaultOptions={legend:{show:false,noColumns:1,labelFormatter:null,container:null,position:"ne",margin:5,sorted:null}};function insertLegend(plot,options,placeholder,legendEntries){if(options.legend.container!=null){$(options.legend.container).html("")}else{placeholder.find(".legend").remove()}if(!options.legend.show){return}var entries=options.legend.legendEntries=legendEntries,plotOffset=options.legend.plotOffset=plot.getPlotOffset(),html=[],entry,labelHtml,iconHtml,j=0,i,pos="",p=options.legend.position,m=options.legend.margin,shape={name:"",label:"",xPos:"",yPos:""};html[j++]='<svg class="legendLayer" style="width:inherit;height:inherit;">';html[j++]='<rect class="background" width="100%" height="100%"/>';html[j++]=svgShapeDefs;var left=0;var columnWidths=[];var style=window.getComputedStyle(document.querySelector("body"));for(i=0;i<entries.length;++i){var columnIndex=i%options.legend.noColumns;entry=entries[i];shape.label=entry.label;var info=plot.getSurface().getTextInfo("",shape.label,{style:style.fontStyle,variant:style.fontVariant,weight:style.fontWeight,size:parseInt(style.fontSize),lineHeight:parseInt(style.lineHeight),family:style.fontFamily});var labelWidth=info.width;var iconWidth=48;if(columnWidths[columnIndex]){if(labelWidth>columnWidths[columnIndex]){columnWidths[columnIndex]=labelWidth+iconWidth}}else{columnWidths[columnIndex]=labelWidth+iconWidth}}for(i=0;i<entries.length;++i){var _columnIndex=i%options.legend.noColumns;entry=entries[i];iconHtml="";shape.label=entry.label;shape.xPos=left+3+"px";left+=columnWidths[_columnIndex];if((i+1)%options.legend.noColumns===0){left=0}shape.yPos=Math.floor(i/options.legend.noColumns)*1.5+"em";if(entry.options.lines.show&&entry.options.lines.fill){shape.name="area";shape.fillColor=entry.color;iconHtml+=getEntryIconHtml(shape)}if(entry.options.bars.show){shape.name="bar";shape.fillColor=entry.color;iconHtml+=getEntryIconHtml(shape)}if(entry.options.lines.show&&!entry.options.lines.fill){shape.name="line";shape.strokeColor=entry.color;shape.strokeWidth=entry.options.lines.lineWidth;iconHtml+=getEntryIconHtml(shape)}if(entry.options.points.show){shape.name=entry.options.points.symbol;shape.strokeColor=entry.color;shape.fillColor=entry.options.points.fillColor;shape.strokeWidth=entry.options.points.lineWidth;iconHtml+=getEntryIconHtml(shape)}labelHtml='<text x="'+shape.xPos+'" y="'+shape.yPos+'" text-anchor="start"><tspan dx="2em" dy="1.2em">'+shape.label+"</tspan></text>";html[j++]="<g>"+iconHtml+labelHtml+"</g>"}html[j++]="</svg>";if(m[0]==null){m=[m,m]}if(p.charAt(0)==="n"){pos+="top:"+(m[1]+plotOffset.top)+"px;"}else if(p.charAt(0)==="s"){pos+="bottom:"+(m[1]+plotOffset.bottom)+"px;"}if(p.charAt(1)==="e"){pos+="right:"+(m[0]+plotOffset.right)+"px;"}else if(p.charAt(1)==="w"){pos+="left:"+(m[0]+plotOffset.left)+"px;"}var width=6;for(i=0;i<columnWidths.length;++i){width+=columnWidths[i]}var legendEl,height=Math.ceil(entries.length/options.legend.noColumns)*1.6;if(!options.legend.container){legendEl=$('<div class="legend" style="position:absolute;'+pos+'">'+html.join("")+"</div>").appendTo(placeholder);legendEl.css("width",width+"px");legendEl.css("height",height+"em");legendEl.css("pointerEvents","none")}else{legendEl=$(html.join("")).appendTo(options.legend.container)[0];options.legend.container.style.width=width+"px";options.legend.container.style.height=height+"em"}}function getEntryIconHtml(shape){var html="",name=shape.name,x=shape.xPos,y=shape.yPos,fill=shape.fillColor,stroke=shape.strokeColor,width=shape.strokeWidth;switch(name){case"circle":html='<use xlink:href="#circle" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'fill="'+fill+'" '+'stroke="'+stroke+'" '+'stroke-width="'+width+'" '+'width="1.5em" height="1.5em"'+"/>";break;case"diamond":html='<use xlink:href="#diamond" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'fill="'+fill+'" '+'stroke="'+stroke+'" '+'stroke-width="'+width+'" '+'width="1.5em" height="1.5em"'+"/>";break;case"cross":html='<use xlink:href="#cross" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'stroke="'+stroke+'" '+'stroke-width="'+width+'" '+'width="1.5em" height="1.5em"'+"/>";break;case"rectangle":html='<use xlink:href="#rectangle" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'fill="'+fill+'" '+'stroke="'+stroke+'" '+'stroke-width="'+width+'" '+'width="1.5em" height="1.5em"'+"/>";break;case"plus":html='<use xlink:href="#plus" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'stroke="'+stroke+'" '+'stroke-width="'+width+'" '+'width="1.5em" height="1.5em"'+"/>";break;case"bar":html='<use xlink:href="#bars" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'fill="'+fill+'" '+'width="1.5em" height="1.5em"'+"/>";break;case"area":html='<use xlink:href="#area" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'fill="'+fill+'" '+'width="1.5em" height="1.5em"'+"/>";break;case"line":html='<use xlink:href="#line" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'stroke="'+stroke+'" '+'stroke-width="'+width+'" '+'width="1.5em" height="1.5em"'+"/>";break;default:html='<use xlink:href="#circle" class="legendIcon" '+'x="'+x+'" '+'y="'+y+'" '+'fill="'+fill+'" '+'stroke="'+stroke+'" '+'stroke-width="'+width+'" '+'width="1.5em" height="1.5em"'+"/>"}return html}var svgShapeDefs=""+"<defs>"+'<symbol id="line" fill="none" viewBox="-5 -5 25 25">'+'<polyline points="0,15 5,5 10,10 15,0"/>'+"</symbol>"+'<symbol id="area" stroke-width="1" viewBox="-5 -5 25 25">'+'<polyline points="0,15 5,5 10,10 15,0, 15,15, 0,15"/>'+"</symbol>"+'<symbol id="bars" stroke-width="1" viewBox="-5 -5 25 25">'+'<polyline points="1.5,15.5 1.5,12.5, 4.5,12.5 4.5,15.5 6.5,15.5 6.5,3.5, 9.5,3.5 9.5,15.5 11.5,15.5 11.5,7.5 14.5,7.5 14.5,15.5 1.5,15.5"/>'+"</symbol>"+'<symbol id="circle" viewBox="-5 -5 25 25">'+'<circle cx="0" cy="15" r="2.5"/>'+'<circle cx="5" cy="5" r="2.5"/>'+'<circle cx="10" cy="10" r="2.5"/>'+'<circle cx="15" cy="0" r="2.5"/>'+"</symbol>"+'<symbol id="rectangle" viewBox="-5 -5 25 25">'+'<rect x="-2.1" y="12.9" width="4.2" height="4.2"/>'+'<rect x="2.9" y="2.9" width="4.2" height="4.2"/>'+'<rect x="7.9" y="7.9" width="4.2" height="4.2"/>'+'<rect x="12.9" y="-2.1" width="4.2" height="4.2"/>'+"</symbol>"+'<symbol id="diamond" viewBox="-5 -5 25 25">'+'<path d="M-3,15 L0,12 L3,15, L0,18 Z"/>'+'<path d="M2,5 L5,2 L8,5, L5,8 Z"/>'+'<path d="M7,10 L10,7 L13,10, L10,13 Z"/>'+'<path d="M12,0 L15,-3 L18,0, L15,3 Z"/>'+"</symbol>"+'<symbol id="cross" fill="none" viewBox="-5 -5 25 25">'+'<path d="M-2.1,12.9 L2.1,17.1, M2.1,12.9 L-2.1,17.1 Z"/>'+'<path d="M2.9,2.9 L7.1,7.1 M7.1,2.9 L2.9,7.1 Z"/>'+'<path d="M7.9,7.9 L12.1,12.1 M12.1,7.9 L7.9,12.1 Z"/>'+'<path d="M12.9,-2.1 L17.1,2.1 M17.1,-2.1 L12.9,2.1 Z"/>'+"</symbol>"+'<symbol id="plus" fill="none" viewBox="-5 -5 25 25">'+'<path d="M0,12 L0,18, M-3,15 L3,15 Z"/>'+'<path d="M5,2 L5,8 M2,5 L8,5 Z"/>'+'<path d="M10,7 L10,13 M7,10 L13,10 Z"/>'+'<path d="M15,-3 L15,3 M12,0 L18,0 Z"/>'+"</symbol>"+"</defs>";function getLegendEntries(series,labelFormatter,sorted){var lf=labelFormatter,legendEntries=series.reduce(function(validEntries,s,i){var labelEval=lf?lf(s.label,s):s.label;if(s.hasOwnProperty("label")?labelEval:true){var entry={label:labelEval||"Plot "+(i+1),color:s.color,options:{lines:s.lines,points:s.points,bars:s.bars}};validEntries.push(entry)}return validEntries},[]);if(sorted){if($.isFunction(sorted)){legendEntries.sort(sorted)}else if(sorted==="reverse"){legendEntries.reverse()}else{var ascending=sorted!=="descending";legendEntries.sort(function(a,b){return a.label===b.label?0:a.label<b.label!==ascending?1:-1})}}return legendEntries}function checkOptions(opts1,opts2){for(var prop in opts1){if(opts1.hasOwnProperty(prop)){if(opts1[prop]!==opts2[prop]){return true}}}return false}function shouldRedraw(oldEntries,newEntries){if(!oldEntries||!newEntries){return true}if(oldEntries.length!==newEntries.length){return true}var i,newEntry,oldEntry,newOpts,oldOpts;for(i=0;i<newEntries.length;i++){newEntry=newEntries[i];oldEntry=oldEntries[i];if(newEntry.label!==oldEntry.label){return true}if(newEntry.color!==oldEntry.color){return true}newOpts=newEntry.options.lines;oldOpts=oldEntry.options.lines;if(checkOptions(newOpts,oldOpts)){return true}newOpts=newEntry.options.points;oldOpts=oldEntry.options.points;if(checkOptions(newOpts,oldOpts)){return true}newOpts=newEntry.options.bars;oldOpts=oldEntry.options.bars;if(checkOptions(newOpts,oldOpts)){return true}}return false}function init(plot){plot.hooks.setupGrid.push(function(plot){var options=plot.getOptions();var series=plot.getData(),labelFormatter=options.legend.labelFormatter,oldEntries=options.legend.legendEntries,oldPlotOffset=options.legend.plotOffset,newEntries=getLegendEntries(series,labelFormatter,options.legend.sorted),newPlotOffset=plot.getPlotOffset();if(shouldRedraw(oldEntries,newEntries)||checkOptions(oldPlotOffset,newPlotOffset)){insertLegend(plot,options,plot.getPlaceholder(),newEntries)}})}$.plot.plugins.push({init:init,options:defaultOptions,name:"legend",version:"1.0"})})(jQuery);(function($){var options={crosshair:{mode:null,color:"rgba(170, 0, 0, 0.80)",lineWidth:1}};function init(plot){var crosshair={x:-1,y:-1,locked:false,highlighted:false};plot.setCrosshair=function setCrosshair(pos){if(!pos){crosshair.x=-1}else{var o=plot.p2c(pos);crosshair.x=Math.max(0,Math.min(o.left,plot.width()));crosshair.y=Math.max(0,Math.min(o.top,plot.height()))}plot.triggerRedrawOverlay()};plot.clearCrosshair=plot.setCrosshair;plot.lockCrosshair=function lockCrosshair(pos){if(pos){plot.setCrosshair(pos)}crosshair.locked=true};plot.unlockCrosshair=function unlockCrosshair(){crosshair.locked=false;crosshair.rect=null};function onMouseOut(e){if(crosshair.locked){return}if(crosshair.x!==-1){crosshair.x=-1;plot.triggerRedrawOverlay()}}function onMouseMove(e){var offset=plot.offset();if(crosshair.locked){var mouseX=Math.max(0,Math.min(e.pageX-offset.left,plot.width()));var mouseY=Math.max(0,Math.min(e.pageY-offset.top,plot.height()));if(mouseX>crosshair.x-4&&mouseX<crosshair.x+4&&mouseY>crosshair.y-4&&mouseY<crosshair.y+4){if(!crosshair.highlighted){crosshair.highlighted=true;plot.triggerRedrawOverlay()}}else{if(crosshair.highlighted){crosshair.highlighted=false;plot.triggerRedrawOverlay()}}return}if(plot.getSelection&&plot.getSelection()){crosshair.x=-1;return}crosshair.x=Math.max(0,Math.min(e.pageX-offset.left,plot.width()));crosshair.y=Math.max(0,Math.min(e.pageY-offset.top,plot.height()));plot.triggerRedrawOverlay()}plot.hooks.bindEvents.push(function(plot,eventHolder){if(!plot.getOptions().crosshair.mode){return}eventHolder.mouseout(onMouseOut);eventHolder.mousemove(onMouseMove)});plot.hooks.drawOverlay.push(function(plot,ctx){var c=plot.getOptions().crosshair;if(!c.mode){return}var plotOffset=plot.getPlotOffset();ctx.save();ctx.translate(plotOffset.left,plotOffset.top);if(crosshair.x!==-1){var adj=plot.getOptions().crosshair.lineWidth%2?.5:0;ctx.strokeStyle=c.color;ctx.lineWidth=c.lineWidth;ctx.lineJoin="round";ctx.beginPath();if(c.mode.indexOf("x")!==-1){var drawX=Math.floor(crosshair.x)+adj;ctx.moveTo(drawX,0);ctx.lineTo(drawX,plot.height())}if(c.mode.indexOf("y")!==-1){var drawY=Math.floor(crosshair.y)+adj;ctx.moveTo(0,drawY);ctx.lineTo(plot.width(),drawY)}if(crosshair.locked){if(crosshair.highlighted)ctx.fillStyle="orange";else ctx.fillStyle=c.color;ctx.fillRect(Math.floor(crosshair.x)+adj-4,Math.floor(crosshair.y)+adj-4,8,8)}ctx.stroke()}ctx.restore()});plot.hooks.shutdown.push(function(plot,eventHolder){eventHolder.unbind("mouseout",onMouseOut);eventHolder.unbind("mousemove",onMouseMove)})}$.plot.plugins.push({init:init,options:options,name:"crosshair",version:"1.0"})})(jQuery);!function(a){var b={tooltip:{show:!1,cssClass:"flotTip",content:"%s | X: %x | Y: %y",xDateFormat:null,yDateFormat:null,monthNames:null,dayNames:null,shifts:{x:10,y:20},defaultTheme:!0,snap:!0,lines:!1,clickTips:!1,onHover:function onHover(a,b){},$compat:!1}};b.tooltipOpts=b.tooltip;var c=function c(a){this.tipPosition={x:0,y:0},this.init(a)};c.prototype.init=function(b){function c(a){var c={};c.x=a.pageX,c.y=a.pageY,b.setTooltipPosition(c)}function d(c,d,g){f.clickmode?(a(b.getPlaceholder()).bind("plothover",e),b.hideTooltip(),f.clickmode=!1):(e(c,d,g),f.getDomElement().is(":visible")&&(a(b.getPlaceholder()).unbind("plothover",e),f.clickmode=!0))}function e(c,d,e){var g=function g(a,b,c,d){return Math.sqrt((c-a)*(c-a)+(d-b)*(d-b))},h=function h(a,b,c,d,e,f,_h){if(!_h||(_h=function(a,b,c,d,e,f){if("undefined"!=typeof c)return{x:c,y:b};if("undefined"!=typeof d)return{x:a,y:d};var g,h=-1/((f-d)/(e-c));return{x:g=(e*(a*h-b+d)+c*(a*-h+b-f))/(h*(e-c)+d-f),y:h*g-h*a+b}}(a,b,c,d,e,f),_h.x>=Math.min(c,e)&&_h.x<=Math.max(c,e)&&_h.y>=Math.min(d,f)&&_h.y<=Math.max(d,f))){var i=d-f,j=e-c,k=c*f-d*e;return Math.abs(i*a+j*b+k)/Math.sqrt(i*i+j*j)}var l=g(a,b,c,d),m=g(a,b,e,f);return l>m?m:l};if(e)b.showTooltip(e,f.tooltipOptions.snap?e:d);else if(f.plotOptions.series.lines.show&&f.tooltipOptions.lines===!0){var i=f.plotOptions.grid.mouseActiveRadius,j={distance:i+1},k=d;a.each(b.getData(),function(a,c){for(var e=0,i=-1,l=1;l<c.data.length;l++)c.data[l-1][0]<=d.x&&c.data[l][0]>=d.x&&(e=l-1,i=l);if(-1===i)return void b.hideTooltip();var m={x:c.data[e][0],y:c.data[e][1]},n={x:c.data[i][0],y:c.data[i][1]},o=h(c.xaxis.p2c(d.x),c.yaxis.p2c(d.y),c.xaxis.p2c(m.x),c.yaxis.p2c(m.y),c.xaxis.p2c(n.x),c.yaxis.p2c(n.y),!1);if(o<j.distance){var p=g(m.x,m.y,d.x,d.y)<g(d.x,d.y,n.x,n.y)?e:i,q=(c.datapoints.pointsize,[d.x,m.y+(n.y-m.y)*((d.x-m.x)/(n.x-m.x))]),r={datapoint:q,dataIndex:p,series:c,seriesIndex:a};j={distance:o,item:r},f.tooltipOptions.snap&&(k={pageX:c.xaxis.p2c(q[0]),pageY:c.yaxis.p2c(q[1])})}}),j.distance<i+1?b.showTooltip(j.item,k):b.hideTooltip()}else b.hideTooltip()}var f=this,g=a.plot.plugins.length;if(this.plotPlugins=[],g)for(var h=0;g>h;h++)this.plotPlugins.push(a.plot.plugins[h].name);b.hooks.bindEvents.push(function(b,g){if(f.plotOptions=b.getOptions(),"boolean"==typeof f.plotOptions.tooltip&&(f.plotOptions.tooltipOpts.show=f.plotOptions.tooltip,f.plotOptions.tooltip=f.plotOptions.tooltipOpts,delete f.plotOptions.tooltipOpts),f.plotOptions.tooltip.show!==!1&&"undefined"!=typeof f.plotOptions.tooltip.show){f.tooltipOptions=f.plotOptions.tooltip,f.tooltipOptions.$compat?(f.wfunc="width",f.hfunc="height"):(f.wfunc="innerWidth",f.hfunc="innerHeight");f.getDomElement();a(b.getPlaceholder()).bind("plothover",e),f.tooltipOptions.clickTips&&a(b.getPlaceholder()).bind("plotclick",d),f.clickmode=!1,a(g).bind("mousemove",c)}}),b.hooks.shutdown.push(function(b,f){a(b.getPlaceholder()).unbind("plothover",e),a(b.getPlaceholder()).unbind("plotclick",d),b.removeTooltip(),a(f).unbind("mousemove",c)}),b.setTooltipPosition=function(b){var c=f.getDomElement(),d=c.outerWidth()+f.tooltipOptions.shifts.x,e=c.outerHeight()+f.tooltipOptions.shifts.y;b.x-a(window).scrollLeft()>a(window)[f.wfunc]()-d&&(b.x-=d,b.x=Math.max(b.x,0)),b.y-a(window).scrollTop()>a(window)[f.hfunc]()-e&&(b.y-=e),isNaN(b.x)?f.tipPosition.x=f.tipPosition.xPrev:(f.tipPosition.x=b.x,f.tipPosition.xPrev=b.x),isNaN(b.y)?f.tipPosition.y=f.tipPosition.yPrev:(f.tipPosition.y=b.y,f.tipPosition.yPrev=b.y)},b.showTooltip=function(a,c,d){var e=f.getDomElement(),g=f.stringFormat(f.tooltipOptions.content,a);""!==g&&(e.html(g),b.setTooltipPosition({x:f.tipPosition.x,y:f.tipPosition.y}),e.css({left:f.tipPosition.x+f.tooltipOptions.shifts.x,top:f.tipPosition.y+f.tooltipOptions.shifts.y}).show(),"function"==typeof f.tooltipOptions.onHover&&f.tooltipOptions.onHover(a,e))},b.hideTooltip=function(){f.getDomElement().hide().html("")},b.removeTooltip=function(){f.getDomElement().remove()}},c.prototype.getDomElement=function(){var b=a("<div>");return this.tooltipOptions&&this.tooltipOptions.cssClass&&(b=a("."+this.tooltipOptions.cssClass),0===b.length&&(b=a("<div />").addClass(this.tooltipOptions.cssClass),b.appendTo("body").hide().css({position:"absolute"}),this.tooltipOptions.defaultTheme&&b.css({background:"#fff","z-index":"1040",padding:"0.4em 0.6em","border-radius":"0.5em","font-size":"0.8em",border:"1px solid #111",display:"none","white-space":"nowrap"}))),b},c.prototype.stringFormat=function(a,b){var c,d,e,f,g,h=/%p\.{0,1}(\d{0,})/,i=/%s/,j=/%c/,k=/%lx/,l=/%ly/,m=/%x\.{0,1}(\d{0,})/,n=/%y\.{0,1}(\d{0,})/,o="%x",p="%y",q="%ct",r="%n";if("undefined"!=typeof b.series.threshold?(c=b.datapoint[0],d=b.datapoint[1],e=b.datapoint[2]):"undefined"!=typeof b.series.curvedLines?(c=b.datapoint[0],d=b.datapoint[1]):"undefined"!=typeof b.series.lines&&b.series.lines.steps?(c=b.series.datapoints.points[2*b.dataIndex],d=b.series.datapoints.points[2*b.dataIndex+1],e=""):(c=b.series.data[b.dataIndex][0],d=b.series.data[b.dataIndex][1],e=b.series.data[b.dataIndex][2]),null===b.series.label&&b.series.originSeries&&(b.series.label=b.series.originSeries.label),"function"==typeof a&&(a=a(b.series.label,c,d,b)),"boolean"==typeof a&&!a)return"";if(e&&(a=a.replace(q,e)),"undefined"!=typeof b.series.percent?f=b.series.percent:"undefined"!=typeof b.series.percents&&(f=b.series.percents[b.dataIndex]),"number"==typeof f&&(a=this.adjustValPrecision(h,a,f)),b.series.hasOwnProperty("pie")&&"undefined"!=typeof b.series.data[0][1]&&(g=b.series.data[0][1]),"number"==typeof g&&(a=a.replace(r,g)),a="undefined"!=typeof b.series.label?a.replace(i,b.series.label):a.replace(i,""),a="undefined"!=typeof b.series.color?a.replace(j,b.series.color):a.replace(j,""),a=this.hasAxisLabel("xaxis",b)?a.replace(k,b.series.xaxis.options.axisLabel):a.replace(k,""),a=this.hasAxisLabel("yaxis",b)?a.replace(l,b.series.yaxis.options.axisLabel):a.replace(l,""),this.isTimeMode("xaxis",b)&&this.isXDateFormat(b)&&(a=a.replace(m,this.timestampToDate(c,this.tooltipOptions.xDateFormat,b.series.xaxis.options))),this.isTimeMode("yaxis",b)&&this.isYDateFormat(b)&&(a=a.replace(n,this.timestampToDate(d,this.tooltipOptions.yDateFormat,b.series.yaxis.options))),"number"==typeof c&&(a=this.adjustValPrecision(m,a,c)),"number"==typeof d&&(a=this.adjustValPrecision(n,a,d)),"undefined"!=typeof b.series.xaxis.ticks){var s;s=this.hasRotatedXAxisTicks(b)?"rotatedTicks":"ticks";var t=b.dataIndex+b.seriesIndex;for(var u in b.series.xaxis[s])if(b.series.xaxis[s].hasOwnProperty(t)&&!this.isTimeMode("xaxis",b)){var v=this.isCategoriesMode("xaxis",b)?b.series.xaxis[s][t].label:b.series.xaxis[s][t].v;v===c&&(a=a.replace(m,b.series.xaxis[s][t].label.replace(/\$/g,"$$$$")))}}if("undefined"!=typeof b.series.yaxis.ticks)for(var w in b.series.yaxis.ticks)if(b.series.yaxis.ticks.hasOwnProperty(w)){var x=this.isCategoriesMode("yaxis",b)?b.series.yaxis.ticks[w].label:b.series.yaxis.ticks[w].v;x===d&&(a=a.replace(n,b.series.yaxis.ticks[w].label.replace(/\$/g,"$$$$")))}return"undefined"!=typeof b.series.xaxis.tickFormatter&&(a=a.replace(o,b.series.xaxis.tickFormatter(c,b.series.xaxis).replace(/\$/g,"$$"))),"undefined"!=typeof b.series.yaxis.tickFormatter&&(a=a.replace(p,b.series.yaxis.tickFormatter(d,b.series.yaxis).replace(/\$/g,"$$"))),a},c.prototype.isTimeMode=function(a,b){return"undefined"!=typeof b.series[a].options.mode&&"time"===b.series[a].options.mode},c.prototype.isXDateFormat=function(a){return"undefined"!=typeof this.tooltipOptions.xDateFormat&&null!==this.tooltipOptions.xDateFormat},c.prototype.isYDateFormat=function(a){return"undefined"!=typeof this.tooltipOptions.yDateFormat&&null!==this.tooltipOptions.yDateFormat},c.prototype.isCategoriesMode=function(a,b){return"undefined"!=typeof b.series[a].options.mode&&"categories"===b.series[a].options.mode},c.prototype.timestampToDate=function(b,c,d){var e=a.plot.dateGenerator(b,d);return a.plot.formatDate(e,c,this.tooltipOptions.monthNames,this.tooltipOptions.dayNames)},c.prototype.adjustValPrecision=function(a,b,c){var d,e=b.match(a);return null!==e&&""!==RegExp.$1&&(d=RegExp.$1,c=c.toFixed(d),b=b.replace(a,c)),b},c.prototype.hasAxisLabel=function(b,c){return-1!==a.inArray("axisLabels",this.plotPlugins)&&"undefined"!=typeof c.series[b].options.axisLabel&&c.series[b].options.axisLabel.length>0},c.prototype.hasRotatedXAxisTicks=function(b){return-1!==a.inArray("tickRotor",this.plotPlugins)&&"undefined"!=typeof b.series.xaxis.rotatedTicks};var d=function d(a){new c(a)};a.plot.plugins.push({init:d,options:b,name:"tooltip",version:"0.8.5"})}(jQuery);!function(o,s,u){var h,m=[],l=o.resize=o.extend(o.resize,{}),c=!1,i="setTimeout",d="resize",w=d+"-special-event",f="pendingDelay",n="activeDelay",a="throttleWindow";function g(e){!0===c&&(c=e||1);for(var t=m.length-1;0<=t;t--){var i,n,a,r=o(m[t]);r[0]==s||r.is(":visible")?(i=r.width(),n=r.height(),!(a=r.data(w))||i===a.w&&n===a.h||(r.trigger(d,[a.w=i,a.h=n]),c=e||!0)):((a=r.data(w)).w=0,a.h=0)}null!==h&&(c&&(null==e||e-c<1e3)?h=s.requestAnimationFrame(g):(h=setTimeout(g,l[f]),c=!1))}l[f]=200,l[n]=20,l[a]=!0,o.event.special[d]={setup:function setup(){if(!l[a]&&this[i])return!1;var e=o(this);m.push(this),e.data(w,{w:e.width(),h:e.height()}),1===m.length&&(h=u,g())},teardown:function teardown(){if(!l[a]&&this[i])return!1;for(var e=o(this),t=m.length-1;0<=t;t--)if(m[t]==this){m.splice(t,1);break}e.removeData(w),m.length||((c?cancelAnimationFrame:clearTimeout)(h),h=null)},add:function add(e){var r;return!(!l[a]&&this[i])&&(o.isFunction(e)?(r=e,t):(r=e.handler,void(e.handler=t)));function t(e,t,i){var n=o(this),a=n.data(w)||{};a.w=t!==u?t:n.width(),a.h=i!==u?i:n.height(),r.apply(this,arguments)}}},s.requestAnimationFrame||(s.requestAnimationFrame=s.webkitRequestAnimationFrame||s.mozRequestAnimationFrame||s.oRequestAnimationFrame||s.msRequestAnimationFrame||function(e,t){return s.setTimeout(function(){e((new Date).getTime())},l[n])}),s.cancelAnimationFrame||(s.cancelAnimationFrame=s.webkitCancelRequestAnimationFrame||s.mozCancelRequestAnimationFrame||s.oCancelRequestAnimationFrame||s.msCancelRequestAnimationFrame||clearTimeout)}(jQuery,window),jQuery.plot.plugins.push({init:function init(t){function i(){var e=t.getPlaceholder();0!==e.width()&&0!==e.height()&&(t.resize(),t.setupGrid(),t.draw())}t.hooks.bindEvents.push(function(e,t){e.getPlaceholder().resize(i)}),t.hooks.shutdown.push(function(e,t){e.getPlaceholder().unbind("resize",i)})},options:{},name:"resize",version:"1.0"});(function($){var types=["DOMMouseScroll","mousewheel"];if($.event.fixHooks){for(var i=types.length;i;){$.event.fixHooks[types[--i]]=$.event.mouseHooks}}$.event.special.mousewheel={setup:function setup(){if(this.addEventListener){for(var i=types.length;i;){this.addEventListener(types[--i],handler,false)}}else{this.onmousewheel=handler}},teardown:function teardown(){if(this.removeEventListener){for(var i=types.length;i;){this.removeEventListener(types[--i],handler,false)}}else{this.onmousewheel=null}}};$.fn.extend({mousewheel:function mousewheel(fn){return fn?this.bind("mousewheel",fn):this.trigger("mousewheel")},unmousewheel:function unmousewheel(fn){return this.unbind("mousewheel",fn)}});function handler(event){var orgEvent=event||window.event,args=[].slice.call(arguments,1),delta=0,returnValue=true,deltaX=0,deltaY=0;event=$.event.fix(orgEvent);event.type="mousewheel";if(orgEvent.wheelDelta){delta=orgEvent.wheelDelta/120}if(orgEvent.detail){delta=-orgEvent.detail/3}deltaY=delta;if(orgEvent.axis!==undefined&&orgEvent.axis===orgEvent.HORIZONTAL_AXIS){deltaY=0;deltaX=-1*delta}if(orgEvent.wheelDeltaY!==undefined){deltaY=orgEvent.wheelDeltaY/120}if(orgEvent.wheelDeltaX!==undefined){deltaX=-1*orgEvent.wheelDeltaX/120}args.unshift(event,delta,deltaX,deltaY);return($.event.dispatch||$.event.handle).apply(this,args)}})(jQuery);(function($){var options={series:{points:{errorbars:null,xerr:{err:"x",show:null,asymmetric:null,upperCap:null,lowerCap:null,color:null,radius:null},yerr:{err:"y",show:null,asymmetric:null,upperCap:null,lowerCap:null,color:null,radius:null}}}};function processRawData(plot,series,data,datapoints){if(!series.points.errorbars){return}var format=[{x:true,number:true,required:true},{y:true,number:true,required:true}];var errors=series.points.errorbars;if(errors==="x"||errors==="xy"){if(series.points.xerr.asymmetric){format.push({x:true,number:true,required:true});format.push({x:true,number:true,required:true})}else{format.push({x:true,number:true,required:true})}}if(errors==="y"||errors==="xy"){if(series.points.yerr.asymmetric){format.push({y:true,number:true,required:true});format.push({y:true,number:true,required:true})}else{format.push({y:true,number:true,required:true})}}datapoints.format=format}function parseErrors(series,i){var points=series.datapoints.points;var exl=null,exu=null,eyl=null,eyu=null;var xerr=series.points.xerr,yerr=series.points.yerr;var eb=series.points.errorbars;if(eb==="x"||eb==="xy"){if(xerr.asymmetric){exl=points[i+2];exu=points[i+3];if(eb==="xy"){if(yerr.asymmetric){eyl=points[i+4];eyu=points[i+5]}else{eyl=points[i+4]}}}else{exl=points[i+2];if(eb==="xy"){if(yerr.asymmetric){eyl=points[i+3];eyu=points[i+4]}else{eyl=points[i+3]}}}}else{if(eb==="y"){if(yerr.asymmetric){eyl=points[i+2];eyu=points[i+3]}else{eyl=points[i+2]}}}if(exu==null)exu=exl;if(eyu==null)eyu=eyl;var errRanges=[exl,exu,eyl,eyu];if(!xerr.show){errRanges[0]=null;errRanges[1]=null}if(!yerr.show){errRanges[2]=null;errRanges[3]=null}return errRanges}function drawSeriesErrors(plot,ctx,s){var points=s.datapoints.points,ps=s.datapoints.pointsize,ax=[s.xaxis,s.yaxis],radius=s.points.radius,err=[s.points.xerr,s.points.yerr],tmp;var invertX=false;if(ax[0].p2c(ax[0].max)<ax[0].p2c(ax[0].min)){invertX=true;tmp=err[0].lowerCap;err[0].lowerCap=err[0].upperCap;err[0].upperCap=tmp}var invertY=false;if(ax[1].p2c(ax[1].min)<ax[1].p2c(ax[1].max)){invertY=true;tmp=err[1].lowerCap;err[1].lowerCap=err[1].upperCap;err[1].upperCap=tmp}for(var i=0;i<s.datapoints.points.length;i+=ps){var errRanges=parseErrors(s,i);for(var e=0;e<err.length;e++){var minmax=[ax[e].min,ax[e].max];if(errRanges[e*err.length]){var x=points[i],y=points[i+1];var upper=[x,y][e]+errRanges[e*err.length+1],lower=[x,y][e]-errRanges[e*err.length];if(err[e].err==="x"){if(y>ax[1].max||y<ax[1].min||upper<ax[0].min||lower>ax[0].max){continue}}if(err[e].err==="y"){if(x>ax[0].max||x<ax[0].min||upper<ax[1].min||lower>ax[1].max){continue}}var drawUpper=true,drawLower=true;if(upper>minmax[1]){drawUpper=false;upper=minmax[1]}if(lower<minmax[0]){drawLower=false;lower=minmax[0]}if(err[e].err==="x"&&invertX||err[e].err==="y"&&invertY){tmp=lower;lower=upper;upper=tmp;tmp=drawLower;drawLower=drawUpper;drawUpper=tmp;tmp=minmax[0];minmax[0]=minmax[1];minmax[1]=tmp}x=ax[0].p2c(x);y=ax[1].p2c(y);upper=ax[e].p2c(upper);lower=ax[e].p2c(lower);minmax[0]=ax[e].p2c(minmax[0]);minmax[1]=ax[e].p2c(minmax[1]);var lw=err[e].lineWidth?err[e].lineWidth:s.points.lineWidth,sw=s.points.shadowSize!=null?s.points.shadowSize:s.shadowSize;if(lw>0&&sw>0){var w=sw/2;ctx.lineWidth=w;ctx.strokeStyle="rgba(0,0,0,0.1)";drawError(ctx,err[e],x,y,upper,lower,drawUpper,drawLower,radius,w+w/2,minmax);ctx.strokeStyle="rgba(0,0,0,0.2)";drawError(ctx,err[e],x,y,upper,lower,drawUpper,drawLower,radius,w/2,minmax)}ctx.strokeStyle=err[e].color?err[e].color:s.color;ctx.lineWidth=lw;drawError(ctx,err[e],x,y,upper,lower,drawUpper,drawLower,radius,0,minmax)}}}}function drawError(ctx,err,x,y,upper,lower,drawUpper,drawLower,radius,offset,minmax){y+=offset;upper+=offset;lower+=offset;if(err.err==="x"){if(upper>x+radius)drawPath(ctx,[[upper,y],[Math.max(x+radius,minmax[0]),y]]);else drawUpper=false;if(lower<x-radius)drawPath(ctx,[[Math.min(x-radius,minmax[1]),y],[lower,y]]);else drawLower=false}else{if(upper<y-radius)drawPath(ctx,[[x,upper],[x,Math.min(y-radius,minmax[0])]]);else drawUpper=false;if(lower>y+radius)drawPath(ctx,[[x,Math.max(y+radius,minmax[1])],[x,lower]]);else drawLower=false}radius=err.radius!=null?err.radius:radius;if(drawUpper){if(err.upperCap==="-"){if(err.err==="x")drawPath(ctx,[[upper,y-radius],[upper,y+radius]]);else drawPath(ctx,[[x-radius,upper],[x+radius,upper]])}else if($.isFunction(err.upperCap)){if(err.err==="x")err.upperCap(ctx,upper,y,radius);else err.upperCap(ctx,x,upper,radius)}}if(drawLower){if(err.lowerCap==="-"){if(err.err==="x")drawPath(ctx,[[lower,y-radius],[lower,y+radius]]);else drawPath(ctx,[[x-radius,lower],[x+radius,lower]])}else if($.isFunction(err.lowerCap)){if(err.err==="x")err.lowerCap(ctx,lower,y,radius);else err.lowerCap(ctx,x,lower,radius)}}}function drawPath(ctx,pts){ctx.beginPath();ctx.moveTo(pts[0][0],pts[0][1]);for(var p=1;p<pts.length;p++){ctx.lineTo(pts[p][0],pts[p][1])}ctx.stroke()}function draw(plot,ctx){var plotOffset=plot.getPlotOffset();ctx.save();ctx.translate(plotOffset.left,plotOffset.top);$.each(plot.getData(),function(i,s){if(s.points.errorbars&&(s.points.xerr.show||s.points.yerr.show)){drawSeriesErrors(plot,ctx,s)}});ctx.restore()}function init(plot){plot.hooks.processRawData.push(processRawData);plot.hooks.draw.push(draw)}$.plot.plugins.push({init:init,options:options,name:"errorbars",version:"1.0"})})(jQuery);!function(r){function o(r,o,e,i){var s="categories"==o.xaxis.options.mode,n="categories"==o.yaxis.options.mode;if(s||n){var a=i.format;if(!a){var t=o;if(a=[],a.push({x:!0,number:!0,required:!0}),a.push({y:!0,number:!0,required:!0}),t.bars.show||t.lines.show&&t.lines.fill){var u=!!(t.bars.show&&t.bars.zero||t.lines.show&&t.lines.zero);a.push({y:!0,number:!0,required:!1,defaultValue:0,autoscale:u}),t.bars.horizontal&&(delete a[a.length-1].y,a[a.length-1].x=!0)}i.format=a}for(var f=0;f<a.length;++f)a[f].x&&s&&(a[f].number=!1),a[f].y&&n&&(a[f].number=!1)}}function e(r){var o=-1;for(var e in r)r[e]>o&&(o=r[e]);return o+1}function i(r){var o=[];for(var e in r.categories){var i=r.categories[e];i>=r.min&&i<=r.max&&o.push([i,e])}return o.sort(function(r,o){return r[0]-o[0]}),o}function s(o,e,s){if("categories"==o[e].options.mode){if(!o[e].categories){var a={},t=o[e].options.categories||{};if(r.isArray(t))for(var u=0;u<t.length;++u)a[t[u]]=u;else for(var f in t)a[f]=t[f];o[e].categories=a}o[e].options.ticks||(o[e].options.ticks=i),n(s,e,o[e].categories)}}function n(r,o,i){for(var s=r.points,n=r.pointsize,a=r.format,t=o.charAt(0),u=e(i),f=0;f<s.length;f+=n)if(null!=s[f])for(var c=0;n>c;++c){var l=s[f+c];null!=l&&a[c][t]&&(l in i||(i[l]=u,++u),s[f+c]=i[l])}}function a(r,o,e){s(o,"xaxis",e),s(o,"yaxis",e)}function t(r){r.hooks.processRawData.push(o),r.hooks.processDatapoints.push(a)}var u={xaxis:{categories:null},yaxis:{categories:null}};r.plot.plugins.push({init:t,options:u,name:"categories",version:"1.0"})}(jQuery);(function($){var options={series:{stack:null}};function init(plot){function findMatchingSeries(s,allseries){var res=null;for(var i=0;i<allseries.length;++i){if(s===allseries[i])break;if(allseries[i].stack===s.stack){res=allseries[i]}}return res}function addBottomPoints(s,datapoints){var formattedPoints=[];for(var i=0;i<datapoints.points.length;i+=2){formattedPoints.push(datapoints.points[i]);formattedPoints.push(datapoints.points[i+1]);formattedPoints.push(0)}datapoints.format.push({x:s.bars.horizontal,y:!s.bars.horizontal,number:true,required:false,computeRange:s.yaxis.options.autoScale!=="none",defaultValue:0});datapoints.points=formattedPoints;datapoints.pointsize=3}function stackData(plot,s,datapoints){if(s.stack==null||s.stack===false)return;var needsBottom=s.bars.show||s.lines.show&&s.lines.fill;var hasBottom=datapoints.pointsize>2&&(s.bars.horizontal?datapoints.format[2].x:datapoints.format[2].y);if(needsBottom&&!hasBottom){addBottomPoints(s,datapoints)}var other=findMatchingSeries(s,plot.getData());if(!other)return;var ps=datapoints.pointsize,points=datapoints.points,otherps=other.datapoints.pointsize,otherpoints=other.datapoints.points,newpoints=[],px,py,intery,qx,qy,bottom,withlines=s.lines.show,horizontal=s.bars.horizontal,withsteps=withlines&&s.lines.steps,fromgap=true,keyOffset=horizontal?1:0,accumulateOffset=horizontal?0:1,i=0,j=0,l,m;while(true){if(i>=points.length)break;l=newpoints.length;if(points[i]==null){for(m=0;m<ps;++m){newpoints.push(points[i+m])}i+=ps}else if(j>=otherpoints.length){if(!withlines){for(m=0;m<ps;++m){newpoints.push(points[i+m])}}i+=ps}else if(otherpoints[j]==null){for(m=0;m<ps;++m){newpoints.push(null)}fromgap=true;j+=otherps}else{px=points[i+keyOffset];py=points[i+accumulateOffset];qx=otherpoints[j+keyOffset];qy=otherpoints[j+accumulateOffset];bottom=0;if(px===qx){for(m=0;m<ps;++m){newpoints.push(points[i+m])}newpoints[l+accumulateOffset]+=qy;bottom=qy;i+=ps;j+=otherps}else if(px>qx){if(withlines&&i>0&&points[i-ps]!=null){intery=py+(points[i-ps+accumulateOffset]-py)*(qx-px)/(points[i-ps+keyOffset]-px);newpoints.push(qx);newpoints.push(intery+qy);for(m=2;m<ps;++m){newpoints.push(points[i+m])}bottom=qy}j+=otherps}else{if(fromgap&&withlines){i+=ps;continue}for(m=0;m<ps;++m){newpoints.push(points[i+m])}if(withlines&&j>0&&otherpoints[j-otherps]!=null){bottom=qy+(otherpoints[j-otherps+accumulateOffset]-qy)*(px-qx)/(otherpoints[j-otherps+keyOffset]-qx)}newpoints[l+accumulateOffset]+=bottom;i+=ps}fromgap=false;if(l!==newpoints.length&&needsBottom){newpoints[l+2]+=bottom}}if(withsteps&&l!==newpoints.length&&l>0&&newpoints[l]!==null&&newpoints[l]!==newpoints[l-ps]&&newpoints[l+1]!==newpoints[l-ps+1]){for(m=0;m<ps;++m){newpoints[l+ps+m]=newpoints[l+m]}newpoints[l+1]=newpoints[l-ps+1]}}datapoints.points=newpoints}plot.hooks.processDatapoints.push(stackData)}$.plot.plugins.push({init:init,options:options,name:"stack",version:"1.2"})})(jQuery);(function($){var REDRAW_ATTEMPTS=10;var REDRAW_SHRINK=.95;function init(plot){var canvas=null,target=null,options=null,maxRadius=null,centerLeft=null,centerTop=null,processed=false,ctx=null;var highlights=[];plot.hooks.processOptions.push(function(plot,options){if(options.series.pie.show){options.grid.show=false;if(options.series.pie.label.show==="auto"){if(options.legend.show){options.series.pie.label.show=false}else{options.series.pie.label.show=true}}if(options.series.pie.radius==="auto"){if(options.series.pie.label.show){options.series.pie.radius=3/4}else{options.series.pie.radius=1}}if(options.series.pie.tilt>1){options.series.pie.tilt=1}else if(options.series.pie.tilt<0){options.series.pie.tilt=0}}});plot.hooks.bindEvents.push(function(plot,eventHolder){var options=plot.getOptions();if(options.series.pie.show){if(options.grid.hoverable){eventHolder.unbind("mousemove").mousemove(onMouseMove);eventHolder.bind("mouseleave",onMouseMove)}if(options.grid.clickable){eventHolder.unbind("click").click(onClick)}}});plot.hooks.shutdown.push(function(plot,eventHolder){eventHolder.unbind("mousemove",onMouseMove);eventHolder.unbind("mouseleave",onMouseMove);eventHolder.unbind("click",onClick);highlights=[]});plot.hooks.processDatapoints.push(function(plot,series,data,datapoints){var options=plot.getOptions();if(options.series.pie.show){processDatapoints(plot,series,data,datapoints)}});plot.hooks.drawOverlay.push(function(plot,octx){var options=plot.getOptions();if(options.series.pie.show){drawOverlay(plot,octx)}});plot.hooks.draw.push(function(plot,newCtx){var options=plot.getOptions();if(options.series.pie.show){draw(plot,newCtx)}});function processDatapoints(plot,series,datapoints){if(!processed){processed=true;canvas=plot.getCanvas();target=$(canvas).parent();options=plot.getOptions();plot.setData(combine(plot.getData()))}}function combine(data){var total=0,combined=0,numCombined=0,color=options.series.pie.combine.color,newdata=[],i,value;for(i=0;i<data.length;++i){value=data[i].data;if($.isArray(value)&&value.length===1){value=value[0]}if($.isArray(value)){if(!isNaN(parseFloat(value[1]))&&isFinite(value[1])){value[1]=+value[1]}else{value[1]=0}}else if(!isNaN(parseFloat(value))&&isFinite(value)){value=[1,+value]}else{value=[1,0]}data[i].data=[value]}for(i=0;i<data.length;++i){total+=data[i].data[0][1]}for(i=0;i<data.length;++i){value=data[i].data[0][1];if(value/total<=options.series.pie.combine.threshold){combined+=value;numCombined++;if(!color){color=data[i].color}}}for(i=0;i<data.length;++i){value=data[i].data[0][1];if(numCombined<2||value/total>options.series.pie.combine.threshold){newdata.push($.extend(data[i],{data:[[1,value]],color:data[i].color,label:data[i].label,angle:value*Math.PI*2/total,percent:value/(total/100)}))}}if(numCombined>1){newdata.push({data:[[1,combined]],color:color,label:options.series.pie.combine.label,angle:combined*Math.PI*2/total,percent:combined/(total/100)})}return newdata}function draw(plot,newCtx){if(!target){return}var canvasWidth=plot.getPlaceholder().width(),canvasHeight=plot.getPlaceholder().height(),legendWidth=target.children().filter(".legend").children().width()||0;ctx=newCtx;processed=false;maxRadius=Math.min(canvasWidth,canvasHeight/options.series.pie.tilt)/2;centerTop=canvasHeight/2+options.series.pie.offset.top;centerLeft=canvasWidth/2;if(options.series.pie.offset.left==="auto"){if(options.legend.position.match("w")){centerLeft+=legendWidth/2}else{centerLeft-=legendWidth/2}if(centerLeft<maxRadius){centerLeft=maxRadius}else if(centerLeft>canvasWidth-maxRadius){centerLeft=canvasWidth-maxRadius}}else{centerLeft+=options.series.pie.offset.left}var slices=plot.getData(),attempts=0;do{if(attempts>0){maxRadius*=REDRAW_SHRINK}attempts+=1;clear();if(options.series.pie.tilt<=.8){drawShadow()}}while(!drawPie()&&attempts<REDRAW_ATTEMPTS);if(attempts>=REDRAW_ATTEMPTS){clear();target.prepend("<div class='error'>Could not draw pie with labels contained inside canvas</div>")}if(plot.setSeries&&plot.insertLegend){plot.setSeries(slices);plot.insertLegend()}function clear(){ctx.clearRect(0,0,canvasWidth,canvasHeight);target.children().filter(".pieLabel, .pieLabelBackground").remove()}function drawShadow(){var shadowLeft=options.series.pie.shadow.left;var shadowTop=options.series.pie.shadow.top;var edge=10;var alpha=options.series.pie.shadow.alpha;var radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius;if(radius>=canvasWidth/2-shadowLeft||radius*options.series.pie.tilt>=canvasHeight/2-shadowTop||radius<=edge){return}ctx.save();ctx.translate(shadowLeft,shadowTop);ctx.globalAlpha=alpha;ctx.fillStyle="#000";ctx.translate(centerLeft,centerTop);ctx.scale(1,options.series.pie.tilt);for(var i=1;i<=edge;i++){ctx.beginPath();ctx.arc(0,0,radius,0,Math.PI*2,false);ctx.fill();radius-=i}ctx.restore()}function drawPie(){var startAngle=Math.PI*options.series.pie.startAngle;var radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius;var i;ctx.save();ctx.translate(centerLeft,centerTop);ctx.scale(1,options.series.pie.tilt);ctx.save();var currentAngle=startAngle;for(i=0;i<slices.length;++i){slices[i].startAngle=currentAngle;drawSlice(slices[i].angle,slices[i].color,true)}ctx.restore();if(options.series.pie.stroke.width>0){ctx.save();ctx.lineWidth=options.series.pie.stroke.width;currentAngle=startAngle;for(i=0;i<slices.length;++i){drawSlice(slices[i].angle,options.series.pie.stroke.color,false)}ctx.restore()}drawDonutHole(ctx);ctx.restore();if(options.series.pie.label.show){return drawLabels()}else return true;function drawSlice(angle,color,fill){if(angle<=0||isNaN(angle)){return}if(fill){ctx.fillStyle=color}else{ctx.strokeStyle=color;ctx.lineJoin="round"}ctx.beginPath();if(Math.abs(angle-Math.PI*2)>1e-9){ctx.moveTo(0,0)}ctx.arc(0,0,radius,currentAngle,currentAngle+angle/2,false);ctx.arc(0,0,radius,currentAngle+angle/2,currentAngle+angle,false);ctx.closePath();currentAngle+=angle;if(fill){ctx.fill()}else{ctx.stroke()}}function drawLabels(){var currentAngle=startAngle;var radius=options.series.pie.label.radius>1?options.series.pie.label.radius:maxRadius*options.series.pie.label.radius;for(var i=0;i<slices.length;++i){if(slices[i].percent>=options.series.pie.label.threshold*100){if(!drawLabel(slices[i],currentAngle,i)){return false}}currentAngle+=slices[i].angle}return true;function drawLabel(slice,startAngle,index){if(slice.data[0][1]===0){return true}var lf=options.legend.labelFormatter,text,plf=options.series.pie.label.formatter;if(lf){text=lf(slice.label,slice)}else{text=slice.label}if(plf){text=plf(text,slice)}var halfAngle=(startAngle+slice.angle+startAngle)/2;var x=centerLeft+Math.round(Math.cos(halfAngle)*radius);var y=centerTop+Math.round(Math.sin(halfAngle)*radius)*options.series.pie.tilt;var html="<span class='pieLabel' id='pieLabel"+index+"' style='position:absolute;top:"+y+"px;left:"+x+"px;'>"+text+"</span>";target.append(html);var label=target.children("#pieLabel"+index);var labelTop=y-label.height()/2;var labelLeft=x-label.width()/2;label.css("top",labelTop);label.css("left",labelLeft);if(0-labelTop>0||0-labelLeft>0||canvasHeight-(labelTop+label.height())<0||canvasWidth-(labelLeft+label.width())<0){return false}if(options.series.pie.label.background.opacity!==0){var c=options.series.pie.label.background.color;if(c==null){c=slice.color}var pos="top:"+labelTop+"px;left:"+labelLeft+"px;";$("<div class='pieLabelBackground' style='position:absolute;width:"+label.width()+"px;height:"+label.height()+"px;"+pos+"background-color:"+c+";'></div>").css("opacity",options.series.pie.label.background.opacity).insertBefore(label)}return true}}}}function drawDonutHole(layer){if(options.series.pie.innerRadius>0){layer.save();var innerRadius=options.series.pie.innerRadius>1?options.series.pie.innerRadius:maxRadius*options.series.pie.innerRadius;layer.globalCompositeOperation="destination-out";layer.beginPath();layer.fillStyle=options.series.pie.stroke.color;layer.arc(0,0,innerRadius,0,Math.PI*2,false);layer.fill();layer.closePath();layer.restore();layer.save();layer.beginPath();layer.strokeStyle=options.series.pie.stroke.color;layer.arc(0,0,innerRadius,0,Math.PI*2,false);layer.stroke();layer.closePath();layer.restore()}}function isPointInPoly(poly,pt){for(var c=false,i=-1,l=poly.length,j=l-1;++i<l;j=i){(poly[i][1]<=pt[1]&&pt[1]<poly[j][1]||poly[j][1]<=pt[1]&&pt[1]<poly[i][1])&&pt[0]<(poly[j][0]-poly[i][0])*(pt[1]-poly[i][1])/(poly[j][1]-poly[i][1])+poly[i][0]&&(c=!c)}return c}function findNearbySlice(mouseX,mouseY){var slices=plot.getData(),options=plot.getOptions(),radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius,x,y;for(var i=0;i<slices.length;++i){var s=slices[i];if(s.pie.show){ctx.save();ctx.beginPath();ctx.moveTo(0,0);ctx.arc(0,0,radius,s.startAngle,s.startAngle+s.angle/2,false);ctx.arc(0,0,radius,s.startAngle+s.angle/2,s.startAngle+s.angle,false);ctx.closePath();x=mouseX-centerLeft;y=mouseY-centerTop;if(ctx.isPointInPath){if(ctx.isPointInPath(mouseX-centerLeft,mouseY-centerTop)){ctx.restore();return{datapoint:[s.percent,s.data],dataIndex:0,series:s,seriesIndex:i}}}else{var p1X=radius*Math.cos(s.startAngle),p1Y=radius*Math.sin(s.startAngle),p2X=radius*Math.cos(s.startAngle+s.angle/4),p2Y=radius*Math.sin(s.startAngle+s.angle/4),p3X=radius*Math.cos(s.startAngle+s.angle/2),p3Y=radius*Math.sin(s.startAngle+s.angle/2),p4X=radius*Math.cos(s.startAngle+s.angle/1.5),p4Y=radius*Math.sin(s.startAngle+s.angle/1.5),p5X=radius*Math.cos(s.startAngle+s.angle),p5Y=radius*Math.sin(s.startAngle+s.angle),arrPoly=[[0,0],[p1X,p1Y],[p2X,p2Y],[p3X,p3Y],[p4X,p4Y],[p5X,p5Y]],arrPoint=[x,y];if(isPointInPoly(arrPoly,arrPoint)){ctx.restore();return{datapoint:[s.percent,s.data],dataIndex:0,series:s,seriesIndex:i}}}ctx.restore()}}return null}function onMouseMove(e){triggerClickHoverEvent("plothover",e)}function onClick(e){triggerClickHoverEvent("plotclick",e)}function triggerClickHoverEvent(eventname,e){var offset=plot.offset();var canvasX=parseInt(e.pageX-offset.left);var canvasY=parseInt(e.pageY-offset.top);var item=findNearbySlice(canvasX,canvasY);if(options.grid.autoHighlight){for(var i=0;i<highlights.length;++i){var h=highlights[i];if(h.auto===eventname&&!(item&&h.series===item.series)){unhighlight(h.series)}}}if(item){highlight(item.series,eventname)}var pos={pageX:e.pageX,pageY:e.pageY};target.trigger(eventname,[pos,item])}function highlight(s,auto){var i=indexOfHighlight(s);if(i===-1){highlights.push({series:s,auto:auto});plot.triggerRedrawOverlay()}else if(!auto){highlights[i].auto=false}}function unhighlight(s){if(s==null){highlights=[];plot.triggerRedrawOverlay()}var i=indexOfHighlight(s);if(i!==-1){highlights.splice(i,1);plot.triggerRedrawOverlay()}}function indexOfHighlight(s){for(var i=0;i<highlights.length;++i){var h=highlights[i];if(h.series===s){return i}}return-1}function drawOverlay(plot,octx){var options=plot.getOptions();var radius=options.series.pie.radius>1?options.series.pie.radius:maxRadius*options.series.pie.radius;octx.save();octx.translate(centerLeft,centerTop);octx.scale(1,options.series.pie.tilt);for(var i=0;i<highlights.length;++i){drawHighlight(highlights[i].series)}drawDonutHole(octx);octx.restore();function drawHighlight(series){if(series.angle<=0||isNaN(series.angle)){return}octx.fillStyle="rgba(255, 255, 255, "+options.series.pie.highlight.opacity+")";octx.beginPath();if(Math.abs(series.angle-Math.PI*2)>1e-9){octx.moveTo(0,0)}octx.arc(0,0,radius,series.startAngle,series.startAngle+series.angle/2,false);octx.arc(0,0,radius,series.startAngle+series.angle/2,series.startAngle+series.angle,false);octx.closePath();octx.fill()}}}var options={series:{pie:{show:false,radius:"auto",innerRadius:0,startAngle:3/2,tilt:1,shadow:{left:5,top:15,alpha:.02},offset:{top:0,left:"auto"},stroke:{color:"#fff",width:1},label:{show:"auto",formatter:function formatter(label,slice){return"<div style='font-size:x-small;text-align:center;padding:2px;color:"+slice.color+";'>"+label+"<br/>"+Math.round(slice.percent)+"%</div>"},radius:1,background:{color:null,opacity:0},threshold:0},combine:{threshold:-1,color:null,label:"Other"},highlight:{opacity:.5}}}};$.plot.plugins.push({init:init,options:options,name:"pie",version:"1.1"})})(jQuery);