﻿/// <reference path="..\..\GSMyAdmin\WebRoot\Scripts\UI.js" />
/// <reference path="..\..\GSMyAdmin\WebRoot\Scripts\API.js" />
/// <reference path="..\..\GSMyAdmin\WebRoot\Scripts\Common.js" />

/* jshint undef: true, unused: false */
/* global API,UI,PluginHandler */

this.plugin = {
    PreInit: function () {
        //Called prior to the plugins initialisation, before the tabs are loaded.
        //This method must not invoke any module/plugin specific API calls.
    },

    PostInit: function () {
        setWizardCallback("SteamLogin", SteamLogin, null);
        setWizardCallback("SteamGuard", SteamGuard, null, null, CancelSteamGuard);
        $("#SteamGuard input[name=code]").enterPressed(SteamGuardEnter);
        $("#SteamLogin input[name=password]").enterPressed(SteamLoginEnter);
        resetWizardHandlers();
    },

    Reset: function () {

    },

    PushedMessage: function (source, message, parameters) {
        switch (message) {
            case "steam_NoUsernamePassword":
                console.log("Server requested steam login credentials.");
                UI.ShowWizard("#tab_steamcmdplugin_SteamLogin");
                break;
            case "steam_NoAccess":
                UI.ShowModalAsync(
                    "Steam Authentication",
                    "Your Steam account does not have access to this server.",
                    UI.Icons.Info,
                    UI.OKActionOnly);
                break;
            case "steam_SteamGuardReq":
                ShowSteamGuard();
                break;
            case "steam_SteamGuardMobileReq":
                ShowSteamMobileAuth();
                break;
            case "steam_Bad2FA":
                UI.ShowModalAsync("Invalid 2FA Code", "Your supplied 2FA code was not valid. Please try again and make sure you are using the correct code", UI.Icons.Warning, UI.OKActionOnly);
        }
    }
};

async function SteamLoginEnter() {
    UI.HideWizard();
    SteamLogin();
}

async function SteamGuardEnter() {
    UI.HideWizard();
    SteamGuard();
}

async function SteamLogin() {
    const details = getForm("#steamLogin_Form");
    await API.steamcmdplugin.SteamUsernamePasswordAsync(details.username, details.password);
    await API.Core.UpdateApplicationAsync();
}

async function ShowSteamGuard() {
    console.log("Server requested steam guard code");
    await sleepAsync(500);
    UI.ShowWizard("#tab_steamcmdplugin_SteamGuard");
}

async function ShowSteamMobileAuth() {
    UI.ShowModalAsync("Authenticate with Steam Guard", "Please open the Steam app on your mobile device and approve the login request to continue with installation.", UI.Icons.Exclamation, UI.OKActionOnly);
}

async function SteamGuard() {
    const details = getForm("#steamGuard_Form");
    await API.steamcmdplugin.SteamGuardCodeAsync(details.code);
}

async function CancelSteamGuard() {
    await API.steamcmdplugin.CancelSteamGuardAsync();
}

this.tabs = [{
    File: "SteamLogin.html", //URL to fetch the tab contents from. Relative to the plugin WebRoot directory.
    ExternalTab: false, //If True, 'File' is treated as an absolute URL to allow contents to be loaded from elsewhere. 
    //Note that the appropriate CORS headers are required on the hosting server to allow this.
    ShortName: "SteamLogin", //Name used for the element. Prefixed with tab_PLUGINNAME_
    Name: "Steam Login", //Display name for the tab.
    Icon: "", //Icon to show in the tab.
    Light: false, //Use the 'light' theme for this tab.
    Category: "",
    IsWizard: true
}, {
    File: "SteamGuard.html", //URL to fetch the tab contents from. Relative to the plugin WebRoot directory.
    ExternalTab: false, //If True, 'File' is treated as an absolute URL to allow contents to be loaded from elsewhere. 
    //Note that the appropriate CORS headers are required on the hosting server to allow this.
    ShortName: "SteamGuard", //Name used for the element. Prefixed with tab_PLUGINNAME_
    Name: "Steam Guard", //Display name for the tab.
    Icon: "", //Icon to show in the tab.
    Light: false, //Use the 'light' theme for this tab.
    Category: "",
    IsWizard: true
}];

this.stylesheet = "Stylesheet.css";    //Styles for tab-specific styles