﻿document.addEventListener("DOMContentLoaded", function (event) { setup(); });

function sharePage() {
    navigator.share({ url: document.location.toString() });
}

function setup() {
    //Does 'body' have the class 'analytics-true'
    if (document.body.classList.contains("analytics-true")) {
        const script = document.createElement('script');
        script.defer = true;
        script.async = true;
        script.src = 'https://metrics.c7rs.com/js/s.js';
        script.setAttribute('data-domain', 'community.cubecoders.com');
        document.head.appendChild(script);
    }

    const shareElement = document.getElementById("shareButton");
    if (document.location.protocol === "https:") {
        shareElement.addEventListener("click", sharePage);
    } else {
        shareElement.classList.add("d-none");
    }

    const copyElement = document.getElementById("copyButton");
    copyElement.addEventListener("click", function () {
        const toCopy = document.getElementById("endpointText").innerText;
        if (navigator.clipboard) {
            navigator.clipboard.writeText(toCopy);
        } else {
            const tempElement = document.createElement("textarea");
            tempElement.value = toCopy;
            document.body.appendChild(tempElement);
            tempElement.select();
            document.execCommand("copy");
            document.body.removeChild(tempElement);
        }
    });

    document.getElementById("AMPLogo").addEventListener("click", function () { window.open("https://cubecoders.com/AMP", "_blank"); });
}