﻿/// <reference path="..\..\GSMyAdmin\WebRoot\Scripts\AMP.js" />
/// <reference path="..\..\GSMyAdmin\WebRoot\Scripts\UI.js" />
/// <reference path="..\..\GSMyAdmin\WebRoot\Scripts\API.js" />
/// <reference path="..\..\GSMyAdmin\WebRoot\Scripts\Common.js" />

/* jshint undef: true, unused: false */
/* global API,UI,PluginHandler */
/* eslint eqeqeq: "off", curly: "error", require-atomic-updates: "off" */

this.plugin = {
    AMPDataLoaded: async function () {
        const exts = currentSettings["GenericModule.Meta.ImportableExtensions"].value();
        for (const e of exts) {
            Features.FileManagerPlugin.RegisterContextMenuHandler(e.substr(1), "Import Configuration", importSettingsFile);
        }
        await API.GenericModule.RequestServerInfoAsync();
    },
    PushedMessage: function (source, message, parameters) {
        switch (message) {
            case "ServerInfoChanged":
            {
                //Turn the parameters object into an array of KeyValuePairVM
                const info = Object.keys(parameters).map(k => new KeyValuePairVM(k, parameters[k]));
                viewModels.support.extraServerInfo.removeAll();
                ko.utils.arrayPushAll(viewModels.support.extraServerInfo, info);
            }
        }
    }
};

async function importSettingsFile(file) {
    const settingUpdates = await API.GenericModule.ImportConfigAsync(file.directory + file.name);
    const available = Object.keys(settingUpdates).length;
    await API.Core.SetConfigs(settingUpdates);
    UI.ShowModalAsync("Import Complete", `${available} entries were successfully imported.`, UI.Icons.Info, UI.OKActionOnly, null, null);
}
